/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import io.sentry.android.core.R;
import io.sentry.android.core.SentryUserFeedbackDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryUserFeedbackButton
extends Button {
    @Nullable
    private View.OnClickListener delegate;

    public SentryUserFeedbackButton(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public SentryUserFeedbackButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public SentryUserFeedbackButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public SentryUserFeedbackButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    @SuppressLint(value={"SetTextI18n"})
    private void init(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        try (@NotNull TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SentryUserFeedbackButton, defStyleAttr, defStyleRes);){
            float dimensionScale = context.getResources().getDisplayMetrics().density;
            float drawablePadding = typedArray.getDimension(R.styleable.SentryUserFeedbackButton_android_drawablePadding, -1.0f);
            int drawableStart = typedArray.getResourceId(R.styleable.SentryUserFeedbackButton_android_drawableStart, -1);
            boolean textAllCaps = typedArray.getBoolean(R.styleable.SentryUserFeedbackButton_android_textAllCaps, false);
            int background = typedArray.getResourceId(R.styleable.SentryUserFeedbackButton_android_background, -1);
            float padding = typedArray.getDimension(R.styleable.SentryUserFeedbackButton_android_padding, -1.0f);
            int textColor = typedArray.getColor(R.styleable.SentryUserFeedbackButton_android_textColor, -1);
            @Nullable String text = typedArray.getString(R.styleable.SentryUserFeedbackButton_android_text);
            if (drawablePadding == -1.0f) {
                this.setCompoundDrawablePadding((int)(4.0f * dimensionScale));
            }
            if (drawableStart == -1) {
                this.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.sentry_user_feedback_button_logo_24, 0, 0, 0);
            }
            this.setAllCaps(textAllCaps);
            if (background == -1) {
                this.setBackgroundResource(R.drawable.sentry_oval_button_ripple_background);
            }
            if (padding == -1.0f) {
                int defaultPadding = (int)(12.0f * dimensionScale);
                this.setPadding(defaultPadding, defaultPadding, defaultPadding, defaultPadding);
            }
            if (textColor == -1) {
                @NotNull TypedValue typedValue = new TypedValue();
                context.getTheme().resolveAttribute(0x1010030, typedValue, true);
                if (Build.VERSION.SDK_INT >= 23) {
                    this.setTextColor(context.getResources().getColor(typedValue.resourceId, context.getTheme()));
                } else {
                    this.setTextColor(context.getResources().getColor(typedValue.resourceId));
                }
            }
            if (text == null) {
                this.setText("Report a Bug");
            }
        }
        this.setOnClickListener(this.delegate);
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.delegate = listener;
        super.setOnClickListener(v -> {
            new SentryUserFeedbackDialog.Builder(this.getContext()).create().show();
            if (this.delegate != null) {
                this.delegate.onClick(v);
            }
        });
    }
}

