/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.graphics.Bitmap;
import io.sentry.Attachment;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.internal.util.Debouncer;
import io.sentry.android.core.internal.util.ScreenshotUtils;
import io.sentry.protocol.SentryTransaction;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ScreenshotEventProcessor
implements EventProcessor {
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final Debouncer debouncer;
    private static final long DEBOUNCE_WAIT_TIME_MS = 2000L;
    private static final int DEBOUNCE_MAX_EXECUTIONS = 3;

    public ScreenshotEventProcessor(@NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.debouncer = new Debouncer(AndroidCurrentDateProvider.getInstance(), 2000L, 3);
        if (options.isAttachScreenshot()) {
            IntegrationUtils.addIntegrationToSdkVersion((String)"Screenshot");
        }
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        return transaction;
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (!event.isErrored()) {
            return event;
        }
        if (!this.options.isAttachScreenshot()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "attachScreenshot is disabled.", new Object[0]);
            return event;
        }
        @Nullable Activity activity = CurrentActivityHolder.getInstance().getActivity();
        if (activity == null || HintUtils.isFromHybridSdk((Hint)hint)) {
            return event;
        }
        boolean shouldDebounce = this.debouncer.checkForDebounce();
        @Nullable SentryAndroidOptions.BeforeCaptureCallback beforeCaptureCallback = this.options.getBeforeScreenshotCaptureCallback();
        if (beforeCaptureCallback != null ? !beforeCaptureCallback.execute(event, hint, shouldDebounce) : shouldDebounce) {
            return event;
        }
        Bitmap screenshot = ScreenshotUtils.captureScreenshot(activity, this.options.getThreadChecker(), this.options.getLogger(), this.buildInfoProvider);
        if (screenshot == null) {
            return event;
        }
        hint.setScreenshot(Attachment.fromByteProvider(() -> ScreenshotUtils.compressBitmapToPng(screenshot, this.options.getLogger()), (String)"screenshot.png", (String)"image/png", (boolean)false));
        hint.set("android:activity", (Object)activity);
        return event;
    }

    @Nullable
    public Long getOrder() {
        return 10000L;
    }
}

