/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.transport.ICurrentDateProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class ANRWatchDog
extends Thread {
    private final boolean reportInDebug;
    private final ANRListener anrListener;
    private final MainLooperHandler uiHandler;
    private final ICurrentDateProvider timeProvider;
    private long pollingIntervalMs;
    private final long timeoutIntervalMillis;
    @NotNull
    private final ILogger logger;
    private volatile long lastKnownActiveUiTimestampMs = 0L;
    private final AtomicBoolean reported = new AtomicBoolean(false);
    @NotNull
    private final Context context;
    private final Runnable ticker;

    ANRWatchDog(long timeoutIntervalMillis, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger, @NotNull Context context) {
        this(() -> SystemClock.uptimeMillis(), timeoutIntervalMillis, 500L, reportInDebug, listener, logger, new MainLooperHandler(), context);
    }

    @TestOnly
    ANRWatchDog(@NotNull ICurrentDateProvider timeProvider, long timeoutIntervalMillis, long pollingIntervalMillis, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger, @NotNull MainLooperHandler uiHandler, @NotNull Context context) {
        super("|ANR-WatchDog|");
        this.timeProvider = timeProvider;
        this.timeoutIntervalMillis = timeoutIntervalMillis;
        this.pollingIntervalMs = pollingIntervalMillis;
        this.reportInDebug = reportInDebug;
        this.anrListener = listener;
        this.logger = logger;
        this.uiHandler = uiHandler;
        this.context = context;
        this.ticker = () -> {
            this.lastKnownActiveUiTimestampMs = timeProvider.getCurrentTimeMillis();
            this.reported.set(false);
        };
        if (timeoutIntervalMillis < this.pollingIntervalMs * 2L) {
            throw new IllegalArgumentException(String.format("ANRWatchDog: timeoutIntervalMillis has to be at least %d ms", this.pollingIntervalMs * 2L));
        }
    }

    @Override
    public void run() {
        this.ticker.run();
        while (!this.isInterrupted()) {
            this.uiHandler.post(this.ticker);
            try {
                Thread.sleep(this.pollingIntervalMs);
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException ignored) {
                    this.logger.log(SentryLevel.WARNING, "Failed to interrupt due to SecurityException: %s", new Object[]{e.getMessage()});
                    return;
                }
                this.logger.log(SentryLevel.WARNING, "Interrupted: %s", new Object[]{e.getMessage()});
                return;
            }
            long unresponsiveDurationMs = this.timeProvider.getCurrentTimeMillis() - this.lastKnownActiveUiTimestampMs;
            if (unresponsiveDurationMs <= this.timeoutIntervalMillis) continue;
            if (!this.reportInDebug && (Debug.isDebuggerConnected() || Debug.waitingForDebugger())) {
                this.logger.log(SentryLevel.DEBUG, "An ANR was detected but ignored because the debugger is connected.", new Object[0]);
                this.reported.set(true);
                continue;
            }
            if (!this.isProcessNotResponding() || !this.reported.compareAndSet(false, true)) continue;
            String message = "Application Not Responding for at least " + this.timeoutIntervalMillis + " ms.";
            ApplicationNotResponding error = new ApplicationNotResponding(message, this.uiHandler.getThread());
            this.anrListener.onAppNotResponding(error);
        }
    }

    private boolean isProcessNotResponding() {
        ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
        if (am != null) {
            List processesInErrorState = null;
            try {
                processesInErrorState = am.getProcessesInErrorState();
            }
            catch (Throwable e) {
                this.logger.log(SentryLevel.ERROR, "Error getting ActivityManager#getProcessesInErrorState.", e);
            }
            if (processesInErrorState != null) {
                for (ActivityManager.ProcessErrorStateInfo item : processesInErrorState) {
                    if (item.condition != 2) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static interface ANRListener {
        public void onAppNotResponding(@NotNull ApplicationNotResponding var1);
    }
}

