/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.debugmeta;

import android.content.Context;
import android.content.res.AssetManager;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.ContextUtils;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.util.DebugMetaPropertiesApplier;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AssetsDebugMetaLoader
implements IDebugMetaLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;

    public AssetsDebugMetaLoader(@NotNull Context context, @NotNull ILogger logger) {
        this.context = ContextUtils.getApplicationContext(context);
        this.logger = logger;
    }

    @Nullable
    public List<Properties> loadDebugMeta() {
        block9: {
            List<Properties> list;
            AssetManager assets = this.context.getAssets();
            BufferedInputStream is = new BufferedInputStream(assets.open(DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME));
            try {
                Properties properties = new Properties();
                properties.load(is);
                list = Collections.singletonList(properties);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    this.logger.log(SentryLevel.INFO, "%s file was not found.", new Object[]{DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME});
                    break block9;
                }
                catch (IOException e) {
                    this.logger.log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", (Throwable)e);
                    break block9;
                }
                catch (RuntimeException e) {
                    this.logger.log(SentryLevel.ERROR, (Throwable)e, "%s file is malformed.", new Object[]{DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME});
                }
            }
            ((InputStream)is).close();
            return list;
        }
        return null;
    }
}

