/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.DateUtils;
import io.sentry.IPerformanceContinuousCollector;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.NoOpTransaction;
import io.sentry.SentryDate;
import io.sentry.SentryNanotimeDate;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SentryFrameMetrics;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SpanFrameMetricsCollector
implements IPerformanceContinuousCollector,
SentryFrameMetricsCollector.FrameMetricsCollectorListener {
    private static final int MAX_FRAMES_COUNT = 3600;
    private static final long ONE_SECOND_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final SentryNanotimeDate EMPTY_NANO_TIME = new SentryNanotimeDate(new Date(0L), 0L);
    private final boolean enabled;
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private volatile String listenerId;
    @NotNull
    private final SortedSet<ISpan> runningSpans = new TreeSet<ISpan>((o1, o2) -> {
        int timeDiff = o1.getStartDate().compareTo(o2.getStartDate());
        if (timeDiff != 0) {
            return timeDiff;
        }
        return o1.getSpanContext().getSpanId().toString().compareTo(o2.getSpanContext().getSpanId().toString());
    });
    @NotNull
    private final ConcurrentSkipListSet<Frame> frames = new ConcurrentSkipListSet();
    private long lastKnownFrameDurationNanos = 16666666L;

    public SpanFrameMetricsCollector(@NotNull SentryAndroidOptions options, @NotNull SentryFrameMetricsCollector frameMetricsCollector) {
        this.frameMetricsCollector = frameMetricsCollector;
        this.enabled = options.isEnablePerformanceV2() && options.isEnableFramesTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpanStarted(@NotNull ISpan span) {
        if (!this.enabled) {
            return;
        }
        if (span instanceof NoOpSpan) {
            return;
        }
        if (span instanceof NoOpTransaction) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.runningSpans.add(span);
            if (this.listenerId == null) {
                this.listenerId = this.frameMetricsCollector.startCollection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpanFinished(@NotNull ISpan span) {
        if (!this.enabled) {
            return;
        }
        if (span instanceof NoOpSpan) {
            return;
        }
        if (span instanceof NoOpTransaction) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.runningSpans.contains(span)) {
                return;
            }
        }
        this.captureFrameMetrics(span);
        object = this.lock;
        synchronized (object) {
            if (this.runningSpans.isEmpty()) {
                this.clear();
            } else {
                @NotNull ISpan oldestSpan = this.runningSpans.first();
                this.frames.headSet((Object)new Frame(SpanFrameMetricsCollector.toNanoTime(oldestSpan.getStartDate()))).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureFrameMetrics(@NotNull ISpan span) {
        Object object = this.lock;
        synchronized (object) {
            boolean removed = this.runningSpans.remove(span);
            if (!removed) {
                return;
            }
            @Nullable SentryDate spanFinishDate = span.getFinishDate();
            if (spanFinishDate == null) {
                return;
            }
            long spanStartNanos = SpanFrameMetricsCollector.toNanoTime(span.getStartDate());
            long spanEndNanos = SpanFrameMetricsCollector.toNanoTime(spanFinishDate);
            long spanDurationNanos = spanEndNanos - spanStartNanos;
            if (spanDurationNanos <= 0L) {
                return;
            }
            @NotNull SentryFrameMetrics frameMetrics = new SentryFrameMetrics();
            long frameDurationNanos = this.lastKnownFrameDurationNanos;
            if (!this.frames.isEmpty()) {
                Frame frame;
                Iterator iterator = this.frames.tailSet((Object)new Frame(spanStartNanos)).iterator();
                while (iterator.hasNext() && (frame = (Frame)iterator.next()).startNanos <= spanEndNanos) {
                    if (frame.startNanos >= spanStartNanos && frame.endNanos <= spanEndNanos) {
                        frameMetrics.addFrame(frame.durationNanos, frame.delayNanos, frame.isSlow, frame.isFrozen);
                    } else if (spanStartNanos > frame.startNanos && spanStartNanos < frame.endNanos || spanEndNanos > frame.startNanos && spanEndNanos < frame.endNanos) {
                        long durationBeforeSpan = Math.max(0L, spanStartNanos - frame.startNanos);
                        long delayBeforeSpan = Math.max(0L, durationBeforeSpan - frame.expectedDurationNanos);
                        long delayWithinSpan = Math.min(frame.delayNanos - delayBeforeSpan, spanDurationNanos);
                        long frameStart = Math.max(spanStartNanos, frame.startNanos);
                        long frameEnd = Math.min(spanEndNanos, frame.endNanos);
                        long frameDuration = frameEnd - frameStart;
                        frameMetrics.addFrame(frameDuration, delayWithinSpan, SentryFrameMetricsCollector.isSlow(frameDuration, frame.expectedDurationNanos), SentryFrameMetricsCollector.isFrozen(frameDuration));
                    }
                    frameDurationNanos = frame.expectedDurationNanos;
                }
            }
            int totalFrameCount = frameMetrics.getSlowFrozenFrameCount();
            long nextScheduledFrameNanos = this.frameMetricsCollector.getLastKnownFrameStartTimeNanos();
            if (nextScheduledFrameNanos != -1L) {
                totalFrameCount += SpanFrameMetricsCollector.addPendingFrameDelay(frameMetrics, frameDurationNanos, spanEndNanos, nextScheduledFrameNanos);
                totalFrameCount += SpanFrameMetricsCollector.interpolateFrameCount(frameMetrics, frameDurationNanos, spanDurationNanos);
            }
            long frameDelayNanos = frameMetrics.getSlowFrameDelayNanos() + frameMetrics.getFrozenFrameDelayNanos();
            double frameDelayInSeconds = (double)frameDelayNanos / 1.0E9;
            span.setData("frames.total", (Object)totalFrameCount);
            span.setData("frames.slow", (Object)frameMetrics.getSlowFrameCount());
            span.setData("frames.frozen", (Object)frameMetrics.getFrozenFrameCount());
            span.setData("frames.delay", (Object)frameDelayInSeconds);
            if (span instanceof ITransaction) {
                span.setMeasurement("frames_total", (Number)totalFrameCount);
                span.setMeasurement("frames_slow", (Number)frameMetrics.getSlowFrameCount());
                span.setMeasurement("frames_frozen", (Number)frameMetrics.getFrozenFrameCount());
                span.setMeasurement("frames_delay", (Number)frameDelayInSeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listenerId != null) {
                this.frameMetricsCollector.stopCollection(this.listenerId);
                this.listenerId = null;
            }
            this.frames.clear();
            this.runningSpans.clear();
        }
    }

    @Override
    public void onFrameMetricCollected(long frameStartNanos, long frameEndNanos, long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen, float refreshRate) {
        long expectedFrameDurationNanos;
        if (this.frames.size() > 3600) {
            return;
        }
        this.lastKnownFrameDurationNanos = expectedFrameDurationNanos = (long)((double)ONE_SECOND_NANOS / (double)refreshRate);
        if (isSlow || isFrozen) {
            this.frames.add(new Frame(frameStartNanos, frameEndNanos, durationNanos, delayNanos, isSlow, isFrozen, expectedFrameDurationNanos));
        }
    }

    private static int interpolateFrameCount(@NotNull SentryFrameMetrics frameMetrics, long frameDurationNanos, long spanDurationNanos) {
        long frameMetricsDurationNanos = frameMetrics.getTotalDurationNanos();
        long nonRenderedDuration = spanDurationNanos - frameMetricsDurationNanos;
        if (nonRenderedDuration > 0L) {
            return (int)Math.ceil((double)nonRenderedDuration / (double)frameDurationNanos);
        }
        return 0;
    }

    private static int addPendingFrameDelay(@NotNull SentryFrameMetrics frameMetrics, long frameDurationNanos, long spanEndNanos, long nextScheduledFrameNanos) {
        long pendingDurationNanos = Math.max(0L, spanEndNanos - nextScheduledFrameNanos);
        boolean isSlow = SentryFrameMetricsCollector.isSlow(pendingDurationNanos, frameDurationNanos);
        if (isSlow) {
            boolean isFrozen = SentryFrameMetricsCollector.isFrozen(pendingDurationNanos);
            long pendingDelayNanos = Math.max(0L, pendingDurationNanos - frameDurationNanos);
            frameMetrics.addFrame(pendingDurationNanos, pendingDelayNanos, true, isFrozen);
            return 1;
        }
        return 0;
    }

    private static long toNanoTime(@NotNull SentryDate date) {
        if (date instanceof SentryNanotimeDate) {
            return date.diff((SentryDate)EMPTY_NANO_TIME);
        }
        long nowUnixInNanos = DateUtils.millisToNanos((long)System.currentTimeMillis());
        long shiftInNanos = nowUnixInNanos - date.nanoTimestamp();
        return System.nanoTime() - shiftInNanos;
    }

    private static class Frame
    implements Comparable<Frame> {
        private final long startNanos;
        private final long endNanos;
        private final long durationNanos;
        private final long delayNanos;
        private final boolean isSlow;
        private final boolean isFrozen;
        private final long expectedDurationNanos;

        Frame(long timestampNanos) {
            this(timestampNanos, timestampNanos, 0L, 0L, false, false, 0L);
        }

        Frame(long startNanos, long endNanos, long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen, long expectedFrameDurationNanos) {
            this.startNanos = startNanos;
            this.endNanos = endNanos;
            this.durationNanos = durationNanos;
            this.delayNanos = delayNanos;
            this.isSlow = isSlow;
            this.isFrozen = isFrozen;
            this.expectedDurationNanos = expectedFrameDurationNanos;
        }

        @Override
        public int compareTo(@NotNull Frame o) {
            return Long.compare(this.endNanos, o.endNanos);
        }
    }
}

