/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import io.sentry.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CpuInfoUtils {
    private static final CpuInfoUtils instance = new CpuInfoUtils();
    @NotNull
    private static final String SYSTEM_CPU_PATH = "/sys/devices/system/cpu";
    @VisibleForTesting
    @NotNull
    static final String CPUINFO_MAX_FREQ_PATH = "cpufreq/cpuinfo_max_freq";
    @NotNull
    private final List<Integer> cpuMaxFrequenciesMhz = new ArrayList<Integer>();

    public static CpuInfoUtils getInstance() {
        return instance;
    }

    private CpuInfoUtils() {
    }

    @NotNull
    public synchronized List<Integer> readMaxFrequencies() {
        if (!this.cpuMaxFrequenciesMhz.isEmpty()) {
            return this.cpuMaxFrequenciesMhz;
        }
        File[] cpuDirs = new File(this.getSystemCpuPath()).listFiles();
        if (cpuDirs == null) {
            return new ArrayList<Integer>();
        }
        for (File cpuDir : cpuDirs) {
            long khz;
            File cpuMaxFreqFile;
            if (!cpuDir.getName().matches("cpu[0-9]+") || !(cpuMaxFreqFile = new File(cpuDir, CPUINFO_MAX_FREQ_PATH)).exists() || !cpuMaxFreqFile.canRead()) continue;
            try {
                String content = FileUtils.readText((File)cpuMaxFreqFile);
                if (content == null) continue;
                khz = Long.parseLong(content.trim());
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            this.cpuMaxFrequenciesMhz.add((int)(khz / 1000L));
        }
        return this.cpuMaxFrequenciesMhz;
    }

    @VisibleForTesting
    @NotNull
    String getSystemCpuPath() {
        return SYSTEM_CPU_PATH;
    }

    @TestOnly
    public void setCpuMaxFrequencies(List<Integer> frequencies) {
        this.cpuMaxFrequenciesMhz.clear();
        this.cpuMaxFrequenciesMhz.addAll(frequencies);
    }

    @TestOnly
    final void clear() {
        this.cpuMaxFrequenciesMhz.clear();
    }
}

