/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import android.app.Activity;
import android.app.Application;
import android.content.ContentProvider;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.sentry.ITransactionProfiler;
import io.sentry.SentryDate;
import io.sentry.SentryNanotimeDate;
import io.sentry.TracesSamplingDecision;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.performance.ActivityLifecycleCallbacksAdapter;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.TimeSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class AppStartMetrics
extends ActivityLifecycleCallbacksAdapter {
    private static long CLASS_LOADED_UPTIME_MS = SystemClock.uptimeMillis();
    @Nullable
    private static volatile AppStartMetrics instance;
    @NotNull
    private AppStartType appStartType = AppStartType.UNKNOWN;
    private boolean appLaunchedInForeground = false;
    @NotNull
    private final TimeSpan appStartSpan = new TimeSpan();
    @NotNull
    private final TimeSpan sdkInitTimeSpan = new TimeSpan();
    @NotNull
    private final TimeSpan applicationOnCreate = new TimeSpan();
    @NotNull
    private final Map<ContentProvider, TimeSpan> contentProviderOnCreates = new HashMap<ContentProvider, TimeSpan>();
    @NotNull
    private final List<ActivityLifecycleTimeSpan> activityLifecycles = new ArrayList<ActivityLifecycleTimeSpan>();
    @Nullable
    private ITransactionProfiler appStartProfiler = null;
    @Nullable
    private TracesSamplingDecision appStartSamplingDecision = null;
    @Nullable
    private SentryDate onCreateTime = null;
    private boolean appLaunchTooLong = false;
    private boolean isCallbackRegistered = false;
    private boolean shouldSendStartMeasurements = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static AppStartMetrics getInstance() {
        if (instance != null) return instance;
        Class<AppStartMetrics> clazz = AppStartMetrics.class;
        synchronized (AppStartMetrics.class) {
            if (instance != null) return instance;
            instance = new AppStartMetrics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AppStartMetrics() {
        this.appLaunchedInForeground = ContextUtils.isForegroundImportance();
    }

    @NotNull
    public TimeSpan getAppStartTimeSpan() {
        return this.appStartSpan;
    }

    @NotNull
    public TimeSpan getSdkInitTimeSpan() {
        return this.sdkInitTimeSpan;
    }

    @NotNull
    public TimeSpan getApplicationOnCreateTimeSpan() {
        return this.applicationOnCreate;
    }

    public void setAppStartType(@NotNull AppStartType appStartType) {
        this.appStartType = appStartType;
    }

    @NotNull
    public AppStartType getAppStartType() {
        return this.appStartType;
    }

    public boolean isAppLaunchedInForeground() {
        return this.appLaunchedInForeground;
    }

    public boolean isColdStartValid() {
        return this.appLaunchedInForeground && !this.appLaunchTooLong;
    }

    @VisibleForTesting
    public void setAppLaunchedInForeground(boolean appLaunchedInForeground) {
        this.appLaunchedInForeground = appLaunchedInForeground;
    }

    @NotNull
    public List<TimeSpan> getContentProviderOnCreateTimeSpans() {
        ArrayList<TimeSpan> spans = new ArrayList<TimeSpan>(this.contentProviderOnCreates.values());
        Collections.sort(spans);
        return spans;
    }

    @NotNull
    public List<ActivityLifecycleTimeSpan> getActivityLifecycleTimeSpans() {
        ArrayList<ActivityLifecycleTimeSpan> spans = new ArrayList<ActivityLifecycleTimeSpan>(this.activityLifecycles);
        Collections.sort(spans);
        return spans;
    }

    public void addActivityLifecycleTimeSpans(@NotNull ActivityLifecycleTimeSpan timeSpan) {
        this.activityLifecycles.add(timeSpan);
    }

    public void onAppStartSpansSent() {
        this.shouldSendStartMeasurements = false;
        this.contentProviderOnCreates.clear();
        this.activityLifecycles.clear();
    }

    public boolean shouldSendStartMeasurements() {
        return this.shouldSendStartMeasurements;
    }

    public void restartAppStart(long uptimeMillis) {
        this.shouldSendStartMeasurements = true;
        this.appLaunchTooLong = false;
        this.appLaunchedInForeground = true;
        this.appStartSpan.reset();
        this.appStartSpan.start();
        this.appStartSpan.setStartedAt(uptimeMillis);
        CLASS_LOADED_UPTIME_MS = this.appStartSpan.getStartUptimeMs();
    }

    public long getClassLoadedUptimeMs() {
        return CLASS_LOADED_UPTIME_MS;
    }

    @NotNull
    public TimeSpan getAppStartTimeSpanWithFallback(@NotNull SentryAndroidOptions options) {
        TimeSpan appStartSpan;
        if (!this.isColdStartValid()) {
            return new TimeSpan();
        }
        if (options.isEnablePerformanceV2() && (appStartSpan = this.getAppStartTimeSpan()).hasStarted()) {
            return appStartSpan;
        }
        return this.getSdkInitTimeSpan();
    }

    @TestOnly
    public void clear() {
        this.appStartType = AppStartType.UNKNOWN;
        this.appStartSpan.reset();
        this.sdkInitTimeSpan.reset();
        this.applicationOnCreate.reset();
        this.contentProviderOnCreates.clear();
        this.activityLifecycles.clear();
        if (this.appStartProfiler != null) {
            this.appStartProfiler.close();
        }
        this.appStartProfiler = null;
        this.appStartSamplingDecision = null;
        this.appLaunchTooLong = false;
        this.appLaunchedInForeground = false;
        this.onCreateTime = null;
        this.isCallbackRegistered = false;
        this.shouldSendStartMeasurements = true;
    }

    @Nullable
    public ITransactionProfiler getAppStartProfiler() {
        return this.appStartProfiler;
    }

    public void setAppStartProfiler(@Nullable ITransactionProfiler appStartProfiler) {
        this.appStartProfiler = appStartProfiler;
    }

    public void setAppStartSamplingDecision(@Nullable TracesSamplingDecision appStartSamplingDecision) {
        this.appStartSamplingDecision = appStartSamplingDecision;
    }

    @Nullable
    public TracesSamplingDecision getAppStartSamplingDecision() {
        return this.appStartSamplingDecision;
    }

    @TestOnly
    @ApiStatus.Internal
    public void setClassLoadedUptimeMs(long classLoadedUptimeMs) {
        CLASS_LOADED_UPTIME_MS = classLoadedUptimeMs;
    }

    public static void onApplicationCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStarted()) {
            instance.applicationOnCreate.setStartedAt(now);
            instance.registerApplicationForegroundCheck(application);
        }
    }

    public void registerApplicationForegroundCheck(@NotNull Application application) {
        if (this.isCallbackRegistered) {
            return;
        }
        this.isCallbackRegistered = true;
        this.appLaunchedInForeground = this.appLaunchedInForeground || ContextUtils.isForegroundImportance();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        new Handler(Looper.getMainLooper()).post(() -> this.checkCreateTimeOnMain(application));
    }

    private void checkCreateTimeOnMain(@NotNull Application application) {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.onCreateTime == null) {
                this.appLaunchedInForeground = false;
                if (this.appStartProfiler != null && this.appStartProfiler.isRunning()) {
                    this.appStartProfiler.close();
                    this.appStartProfiler = null;
                }
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        });
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (!this.appLaunchedInForeground || this.onCreateTime != null) {
            return;
        }
        this.onCreateTime = new SentryNanotimeDate();
        long spanStartMillis = this.appStartSpan.getStartTimestampMs();
        long spanEndMillis = this.appStartSpan.hasStopped() ? this.appStartSpan.getProjectedStopTimestampMs() : System.currentTimeMillis();
        long durationMillis = spanEndMillis - spanStartMillis;
        if (durationMillis > TimeUnit.MINUTES.toMillis(1L)) {
            this.appLaunchTooLong = true;
        }
    }

    public static void onApplicationPostCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStopped()) {
            instance.applicationOnCreate.setDescription(application.getClass().getName() + ".onCreate");
            instance.applicationOnCreate.setStoppedAt(now);
        }
    }

    public static void onContentProviderCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = new TimeSpan();
        measurement.setStartedAt(now);
        AppStartMetrics.getInstance().contentProviderOnCreates.put(contentProvider, measurement);
    }

    public static void onContentProviderPostCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = AppStartMetrics.getInstance().contentProviderOnCreates.get(contentProvider);
        if (measurement != null && measurement.hasNotStopped()) {
            measurement.setDescription(contentProvider.getClass().getName() + ".onCreate");
            measurement.setStoppedAt(now);
        }
    }

    public static enum AppStartType {
        UNKNOWN,
        COLD,
        WARM;

    }
}

