/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.SentryLevel;
import io.sentry.Session;
import io.sentry.android.core.AppState;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class LifecycleWatcher
implements DefaultLifecycleObserver {
    private final AtomicLong lastUpdatedSession = new AtomicLong(0L);
    private final AtomicBoolean isFreshSession = new AtomicBoolean(false);
    private final long sessionIntervalMillis;
    @Nullable
    private TimerTask timerTask;
    @NotNull
    private final Timer timer = new Timer(true);
    @NotNull
    private final Object timerLock = new Object();
    @NotNull
    private final IHub hub;
    private final boolean enableSessionTracking;
    private final boolean enableAppLifecycleBreadcrumbs;
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs) {
        this(hub, sessionIntervalMillis, enableSessionTracking, enableAppLifecycleBreadcrumbs, CurrentDateProvider.getInstance());
    }

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs, @NotNull ICurrentDateProvider currentDateProvider) {
        this.sessionIntervalMillis = sessionIntervalMillis;
        this.enableSessionTracking = enableSessionTracking;
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
        this.hub = hub;
        this.currentDateProvider = currentDateProvider;
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.startSession();
        this.addAppBreadcrumb("foreground");
        AppState.getInstance().setInBackground(false);
    }

    private void startSession() {
        this.cancelTask();
        long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
        this.hub.configureScope(scope -> {
            Session currentSession;
            if (this.lastUpdatedSession.get() == 0L && (currentSession = scope.getSession()) != null && currentSession.getStarted() != null) {
                this.lastUpdatedSession.set(currentSession.getStarted().getTime());
                this.isFreshSession.set(true);
            }
        });
        long lastUpdatedSession = this.lastUpdatedSession.get();
        if (lastUpdatedSession == 0L || lastUpdatedSession + this.sessionIntervalMillis <= currentTimeMillis) {
            if (this.enableSessionTracking) {
                this.hub.startSession();
            }
            this.hub.getOptions().getReplayController().start();
        } else if (!this.isFreshSession.get()) {
            this.hub.getOptions().getReplayController().resume();
        }
        this.isFreshSession.set(false);
        this.lastUpdatedSession.set(currentTimeMillis);
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
        this.lastUpdatedSession.set(currentTimeMillis);
        this.hub.getOptions().getReplayController().pause();
        this.scheduleEndSession();
        AppState.getInstance().setInBackground(true);
        this.addAppBreadcrumb("background");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEndSession() {
        Object object = this.timerLock;
        synchronized (object) {
            this.cancelTask();
            if (this.timer != null) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (LifecycleWatcher.this.enableSessionTracking) {
                            LifecycleWatcher.this.hub.endSession();
                        }
                        LifecycleWatcher.this.hub.getOptions().getReplayController().stop();
                    }
                };
                this.timer.schedule(this.timerTask, this.sessionIntervalMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTask() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }
    }

    private void addAppBreadcrumb(@NotNull String state) {
        if (this.enableAppLifecycleBreadcrumbs) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setCategory("app.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    @TestOnly
    @Nullable
    TimerTask getTimerTask() {
        return this.timerTask;
    }

    @TestOnly
    @NotNull
    Timer getTimer() {
        return this.timer;
    }
}

