/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import io.sentry.IConnectionStatusProvider;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.internal.util.Permissions;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AndroidConnectionStatusProvider
implements IConnectionStatusProvider {
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final Map<IConnectionStatusProvider.IConnectionStatusObserver, ConnectivityManager.NetworkCallback> registeredCallbacks;

    public AndroidConnectionStatusProvider(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        this.context = ContextUtils.getApplicationContext(context);
        this.logger = logger;
        this.buildInfoProvider = buildInfoProvider;
        this.registeredCallbacks = new HashMap<IConnectionStatusProvider.IConnectionStatusObserver, ConnectivityManager.NetworkCallback>();
    }

    @NotNull
    public IConnectionStatusProvider.ConnectionStatus getConnectionStatus() {
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(this.context, this.logger);
        if (connectivityManager == null) {
            return IConnectionStatusProvider.ConnectionStatus.UNKNOWN;
        }
        return AndroidConnectionStatusProvider.getConnectionStatus(this.context, connectivityManager, this.logger);
    }

    @Nullable
    public String getConnectionType() {
        return AndroidConnectionStatusProvider.getConnectionType(this.context, this.logger, this.buildInfoProvider);
    }

    @SuppressLint(value={"NewApi"})
    public boolean addConnectionStatusObserver(final @NotNull IConnectionStatusProvider.IConnectionStatusObserver observer) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            this.logger.log(SentryLevel.DEBUG, "addConnectionStatusObserver requires Android 5+.", new Object[0]);
            return false;
        }
        ConnectivityManager.NetworkCallback callback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(@NonNull Network network) {
                observer.onConnectionStatusChanged(AndroidConnectionStatusProvider.this.getConnectionStatus());
            }

            public void onLosing(@NonNull Network network, int maxMsToLive) {
                observer.onConnectionStatusChanged(AndroidConnectionStatusProvider.this.getConnectionStatus());
            }

            public void onLost(@NonNull Network network) {
                observer.onConnectionStatusChanged(AndroidConnectionStatusProvider.this.getConnectionStatus());
            }

            public void onUnavailable() {
                observer.onConnectionStatusChanged(AndroidConnectionStatusProvider.this.getConnectionStatus());
            }
        };
        this.registeredCallbacks.put(observer, callback);
        return AndroidConnectionStatusProvider.registerNetworkCallback(this.context, this.logger, this.buildInfoProvider, callback);
    }

    public void removeConnectionStatusObserver(@NotNull IConnectionStatusProvider.IConnectionStatusObserver observer) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ConnectivityManager.NetworkCallback callback = this.registeredCallbacks.remove(observer);
        if (callback != null) {
            AndroidConnectionStatusProvider.unregisterNetworkCallback(this.context, this.logger, this.buildInfoProvider, callback);
        }
    }

    @NotNull
    private static IConnectionStatusProvider.ConnectionStatus getConnectionStatus(@NotNull Context context, @NotNull ConnectivityManager connectivityManager, @NotNull ILogger logger) {
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return IConnectionStatusProvider.ConnectionStatus.NO_PERMISSION;
        }
        try {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo == null) {
                logger.log(SentryLevel.INFO, "NetworkInfo is null, there's no active network.", new Object[0]);
                return IConnectionStatusProvider.ConnectionStatus.DISCONNECTED;
            }
            return activeNetworkInfo.isConnected() ? IConnectionStatusProvider.ConnectionStatus.CONNECTED : IConnectionStatusProvider.ConnectionStatus.DISCONNECTED;
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "Could not retrieve Connection Status", t);
            return IConnectionStatusProvider.ConnectionStatus.UNKNOWN;
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt", "MissingPermission", "NewApi"})
    @Nullable
    public static String getConnectionType(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return null;
        }
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return null;
        }
        try {
            boolean ethernet = false;
            boolean wifi = false;
            boolean cellular = false;
            if (buildInfoProvider.getSdkInfoVersion() >= 23) {
                Network activeNetwork = connectivityManager.getActiveNetwork();
                if (activeNetwork == null) {
                    logger.log(SentryLevel.INFO, "Network is null and cannot check network status", new Object[0]);
                    return null;
                }
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
                if (networkCapabilities == null) {
                    logger.log(SentryLevel.INFO, "NetworkCapabilities is null and cannot check network type", new Object[0]);
                    return null;
                }
                if (networkCapabilities.hasTransport(3)) {
                    ethernet = true;
                }
                if (networkCapabilities.hasTransport(1)) {
                    wifi = true;
                }
                if (networkCapabilities.hasTransport(0)) {
                    cellular = true;
                }
            } else {
                NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetworkInfo == null) {
                    logger.log(SentryLevel.INFO, "NetworkInfo is null, there's no active network.", new Object[0]);
                    return null;
                }
                int type = activeNetworkInfo.getType();
                int TYPE_ETHERNET = 9;
                boolean TYPE_WIFI = true;
                boolean TYPE_MOBILE = false;
                switch (type) {
                    case 9: {
                        ethernet = true;
                        break;
                    }
                    case 1: {
                        wifi = true;
                        break;
                    }
                    case 0: {
                        cellular = true;
                    }
                }
            }
            if (ethernet) {
                return "ethernet";
            }
            if (wifi) {
                return "wifi";
            }
            if (cellular) {
                return "cellular";
            }
        }
        catch (Throwable exception) {
            logger.log(SentryLevel.ERROR, "Failed to retrieve network info", exception);
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static String getConnectionType(@NotNull NetworkCapabilities networkCapabilities, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        if (networkCapabilities.hasTransport(3)) {
            return "ethernet";
        }
        if (networkCapabilities.hasTransport(1)) {
            return "wifi";
        }
        if (networkCapabilities.hasTransport(0)) {
            return "cellular";
        }
        return null;
    }

    @Nullable
    private static ConnectivityManager getConnectivityManager(@NotNull Context context, @NotNull ILogger logger) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            logger.log(SentryLevel.INFO, "ConnectivityManager is null and cannot check network status", new Object[0]);
        }
        return connectivityManager;
    }

    @SuppressLint(value={"MissingPermission", "NewApi"})
    public static boolean registerNetworkCallback(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ConnectivityManager.NetworkCallback networkCallback) {
        if (buildInfoProvider.getSdkInfoVersion() < 24) {
            logger.log(SentryLevel.DEBUG, "NetworkCallbacks need Android N+.", new Object[0]);
            return false;
        }
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return false;
        }
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return false;
        }
        try {
            connectivityManager.registerDefaultNetworkCallback(networkCallback);
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "registerDefaultNetworkCallback failed", t);
            return false;
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static void unregisterNetworkCallback(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ConnectivityManager.NetworkCallback networkCallback) {
        if (buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return;
        }
        try {
            connectivityManager.unregisterNetworkCallback(networkCallback);
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "unregisterNetworkCallback failed", t);
        }
    }

    @TestOnly
    @NotNull
    public Map<IConnectionStatusProvider.IConnectionStatusObserver, ConnectivityManager.NetworkCallback> getRegisteredCallbacks() {
        return this.registeredCallbacks;
    }
}

