/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.Build;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.lang.reflect.Method;

final class NdkIntegration
implements Integration {
    NdkIntegration() {
    }

    private boolean isNdkAvailable() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void register(IHub hub, SentryOptions options) {
        if (options.isEnableNdk() && this.isNdkAvailable()) {
            try {
                Class<?> cls = Class.forName("io.sentry.android.ndk.SentryNdk");
                Method method = cls.getMethod("init", SentryOptions.class);
                Object[] args = new Object[]{options};
                method.invoke(null, args);
            }
            catch (ClassNotFoundException e) {
                options.setEnableNdk(false);
                options.getLogger().log(SentryLevel.ERROR, "Failed to load SentryNdk.", (Throwable)e);
            }
            catch (Exception e) {
                options.setEnableNdk(false);
                options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", (Throwable)e);
            }
        } else {
            options.setEnableNdk(false);
        }
    }
}

