/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;

final class ManifestMetadataReader {
    static final String DSN_KEY = "io.sentry.dsn";
    static final String DEBUG_KEY = "io.sentry.debug";
    static final String ANR_ENABLE = "io.sentry.anr.enable";
    static final String ANR_REPORT_DEBUG = "io.sentry.anr.report-debug";
    static final String ANR_TIMEOUT_INTERVAL_MILLS = "io.sentry.anr.timeout-interval-mills";
    static final String AUTO_INIT = "io.sentry.auto-init";
    static final String ENABLE_NDK = "io.sentry.ndk.enable";

    private ManifestMetadataReader() {
    }

    static void applyMetadata(Context context, SentryAndroidOptions options) {
        if (context == null) {
            throw new IllegalArgumentException("The application context is required.");
        }
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                boolean debug = metadata.getBoolean(DEBUG_KEY, options.isDebug());
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"debug read: %s", (Object[])new Object[]{debug});
                options.setDebug(debug);
                boolean isAnrEnabled = metadata.getBoolean(ANR_ENABLE, options.isAnrEnabled());
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"isAnrEnabled read: %s", (Object[])new Object[]{isAnrEnabled});
                options.setAnrEnabled(isAnrEnabled);
                boolean isAnrReportInDebug = metadata.getBoolean(ANR_REPORT_DEBUG, options.isAnrReportInDebug());
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"isAnrReportInDebug read: %s", (Object[])new Object[]{isAnrReportInDebug});
                options.setAnrReportInDebug(isAnrReportInDebug);
                int anrTimeoutIntervalMills = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLS, options.getAnrTimeoutIntervalMills());
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"anrTimeoutIntervalMills read: %d", (Object[])new Object[]{anrTimeoutIntervalMills});
                options.setAnrTimeoutIntervalMills(anrTimeoutIntervalMills);
                String dsn = metadata.getString(DSN_KEY, null);
                if (dsn != null) {
                    ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"DSN read: %s", (Object[])new Object[]{dsn});
                    options.setDsn(dsn);
                }
                boolean ndk = metadata.getBoolean(ENABLE_NDK, options.isEnableNdk());
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"NDK read: %s", (Object[])new Object[]{ndk});
                options.setEnableNdk(ndk);
            }
            ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.INFO, (String)"Retrieving configuration from AndroidManifest.xml", (Object[])new Object[0]);
        }
        catch (Exception e) {
            ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.ERROR, (String)"Failed to read configuration from android manifest metadata.", (Throwable)e);
        }
    }

    static boolean isAutoInit(Context context, ILogger logger) {
        if (context == null) {
            throw new IllegalArgumentException("The application context is required.");
        }
        boolean autoInit = true;
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                autoInit = metadata.getBoolean(AUTO_INIT, true);
                ILogger.logIfNotNull((ILogger)logger, (SentryLevel)SentryLevel.DEBUG, (String)"Auto-init: %s", (Object[])new Object[]{autoInit});
            }
            ILogger.logIfNotNull((ILogger)logger, (SentryLevel)SentryLevel.INFO, (String)"Retrieving auto-init from AndroidManifest.xml", (Object[])new Object[0]);
        }
        catch (Exception e) {
            ILogger.logIfNotNull((ILogger)logger, (SentryLevel)SentryLevel.ERROR, (String)"Failed to read auto-init from android manifest metadata.", (Throwable)e);
        }
        return autoInit;
    }

    private static Bundle getMetadata(Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        return app.metaData;
    }
}

