/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.store;

import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.server.env.ContainerHelper;
import io.seata.server.storage.file.FlushDiskMode;

public class StoreConfig {
    private static final Configuration CONFIGURATION = ConfigurationFactory.getInstance();
    private static StoreMode storeMode;
    private static SessionMode sessionMode;
    private static LockMode lockMode;
    private static final int DEFAULT_MAX_BRANCH_SESSION_SIZE = 16384;
    private static final int DEFAULT_MAX_GLOBAL_SESSION_SIZE = 512;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;

    public static void setStartupParameter(String storeMode, String sessionMode, String lockMode) {
        if (StringUtils.isNotBlank((String)storeMode)) {
            StoreConfig.storeMode = StoreMode.get(storeMode);
        }
        if (StringUtils.isNotBlank((String)sessionMode)) {
            StoreConfig.sessionMode = SessionMode.get(sessionMode);
        }
        if (StringUtils.isNotBlank((String)lockMode)) {
            StoreConfig.lockMode = LockMode.get(lockMode);
        }
    }

    public static int getMaxBranchSessionSize() {
        return CONFIGURATION.getInt("store.file.maxBranchSessionSize", 16384);
    }

    public static int getMaxGlobalSessionSize() {
        return CONFIGURATION.getInt("store.file.maxGlobalSessionSize", 512);
    }

    public static int getFileWriteBufferCacheSize() {
        return CONFIGURATION.getInt("store.file.fileWriteBufferCacheSize", 16384);
    }

    public static FlushDiskMode getFlushDiskMode() {
        return FlushDiskMode.findDiskMode(CONFIGURATION.getConfig("store.file.flushDiskMode"));
    }

    private static StoreMode getStoreMode() {
        if (null != storeMode) {
            return storeMode;
        }
        String storeModeEnv = ContainerHelper.getStoreMode();
        if (StringUtils.isNotBlank((String)storeModeEnv)) {
            return StoreMode.get(storeModeEnv);
        }
        String storeModeConfig = CONFIGURATION.getConfig("store.mode", "file");
        return StoreMode.get(storeModeConfig);
    }

    public static SessionMode getSessionMode() {
        if (null != sessionMode) {
            return sessionMode;
        }
        String sessionModeEnv = ContainerHelper.getSessionStoreMode();
        if (StringUtils.isNotBlank((String)sessionModeEnv)) {
            return SessionMode.get(sessionModeEnv);
        }
        String sessionModeConfig = CONFIGURATION.getConfig("store.session.mode");
        if (StringUtils.isNotBlank((String)sessionModeConfig)) {
            return SessionMode.get(sessionModeConfig);
        }
        return SessionMode.get(StoreConfig.getStoreMode().name());
    }

    public static LockMode getLockMode() {
        if (null != lockMode) {
            return lockMode;
        }
        String lockModeEnv = ContainerHelper.getLockStoreMode();
        if (StringUtils.isNotBlank((String)lockModeEnv)) {
            return LockMode.get(lockModeEnv);
        }
        String lockModeConfig = CONFIGURATION.getConfig("store.lock.mode");
        if (StringUtils.isNotBlank((String)lockModeConfig)) {
            return LockMode.get(lockModeConfig);
        }
        return LockMode.get(StoreConfig.getStoreMode().name());
    }

    public static enum LockMode {
        FILE("file"),
        DB("db"),
        REDIS("redis"),
        RAFT("raft");

        private String name;

        private LockMode(String name) {
            this.name = name;
        }

        public static LockMode get(String name) {
            for (LockMode mode : LockMode.values()) {
                if (!mode.getName().equalsIgnoreCase(name)) continue;
                return mode;
            }
            throw new IllegalArgumentException("unknown lock mode:" + name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum SessionMode {
        FILE("file"),
        DB("db"),
        REDIS("redis"),
        RAFT("raft");

        private String name;

        private SessionMode(String name) {
            this.name = name;
        }

        public static SessionMode get(String name) {
            for (SessionMode mode : SessionMode.values()) {
                if (!mode.getName().equalsIgnoreCase(name)) continue;
                return mode;
            }
            throw new IllegalArgumentException("unknown session mode:" + name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum StoreMode {
        FILE("file"),
        DB("db"),
        REDIS("redis"),
        RAFT("raft");

        private String name;

        private StoreMode(String name) {
            this.name = name;
        }

        public static StoreMode get(String name) {
            for (StoreMode mode : StoreMode.values()) {
                if (!mode.getName().equalsIgnoreCase(name)) continue;
                return mode;
            }
            throw new IllegalArgumentException("unknown store mode:" + name);
        }

        public String getName() {
            return this.name;
        }
    }
}

