/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.common.exception.StoreException;
import io.seata.common.io.FileLoader;
import io.seata.server.storage.redis.JedisPooledFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public class LuaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuaParser.class);
    private static final String WHITE_SPACE = " ";
    private static final String ANNOTATION_LUA = "--";
    private static final Map<String, String> LUA_FILE_MAP = new HashMap<String, String>();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getEvalShaMapFromFile(String fileName) throws IOException {
        File luaFile = FileLoader.load((String)fileName);
        if (luaFile == null) {
            throw new IOException("no lua file: " + fileName);
        }
        StringBuilder luaByFile = new StringBuilder();
        try (FileInputStream fis = new FileInputStream(luaFile);){
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(ANNOTATION_LUA)) continue;
                luaByFile.append(line);
                luaByFile.append(WHITE_SPACE);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        LUA_FILE_MAP.put(fileName, luaByFile.toString());
        ConcurrentHashMap<String, String> resultMap = new ConcurrentHashMap<String, String>(1);
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            resultMap.put(fileName, jedis.scriptLoad(luaByFile.toString()));
            ConcurrentHashMap<String, String> concurrentHashMap = resultMap;
            return concurrentHashMap;
        }
        catch (UnsupportedOperationException | JedisDataException e) {
            throw new IOException(e);
        }
    }

    public static <T> T getObjectFromJson(String json, Class<T> classz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, classz);
        }
        catch (JsonProcessingException e) {
            throw new StoreException(e.getMessage());
        }
    }

    public static <T> List<T> getListFromJson(String json, Class<T> classz) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(json, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            throw new StoreException(e.getMessage());
        }
    }

    public static Object jedisEvalSha(Jedis jedis, String luaSHA, String luaFileName, List<String> keys, List<String> args) {
        try {
            return jedis.evalsha(luaSHA, keys, args);
        }
        catch (JedisNoScriptException e) {
            LOGGER.warn("try to reload the lua script and execute,jedis ex: " + e.getMessage());
            jedis.scriptLoad(LUA_FILE_MAP.get(luaFileName));
            return jedis.evalsha(luaSHA, keys, args);
        }
    }

    public static final class LuaErrorStatus {
        public static final String ANOTHER_ROLLBACKING = "AnotherRollbackIng";
        public static final String ANOTHER_HOLDING = "AnotherHoldIng";
        public static final String XID_NOT_EXISTED = "NotExisted";
        public static final String ILLEGAL_CHANGE_STATUS = "ChangeStatusFail";
    }

    public static final class LuaResult
    implements Serializable {
        private static final long serialVersionUID = -4160065043902060730L;
        private Boolean success;
        private String status;
        private String data;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String toString() {
            return "LuaResult{success=" + this.success + ", type='" + this.status + '\'' + ", data='" + this.data + '\'' + '}';
        }
    }
}

