/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.raft.lock;

import com.alipay.sofa.jraft.Closure;
import io.seata.common.loader.LoadLevel;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import io.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import io.seata.server.cluster.raft.sync.msg.RaftSyncMsgType;
import io.seata.server.cluster.raft.sync.msg.dto.BranchTransactionDTO;
import io.seata.server.cluster.raft.sync.msg.dto.GlobalTransactionDTO;
import io.seata.server.cluster.raft.util.RaftTaskUtil;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.storage.file.lock.FileLockManager;
import java.util.concurrent.CompletableFuture;

@LoadLevel(name="raft")
public class RaftLockManager
extends FileLockManager {
    @Override
    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        GlobalTransactionDTO globalTransactionDTO = new GlobalTransactionDTO();
        globalTransactionDTO.setXid(globalSession.getXid());
        RaftGlobalSessionSyncMsg raftSyncMsg = new RaftGlobalSessionSyncMsg(RaftSyncMsgType.RELEASE_GLOBAL_SESSION_LOCK, globalTransactionDTO);
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        Closure closure = status -> {
            if (status.isOk()) {
                try {
                    completableFuture.complete(this.localReleaseGlobalSessionLock(globalSession));
                }
                catch (TransactionException e) {
                    completableFuture.completeExceptionally(e);
                }
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + status.getErrorMsg()));
            }
        };
        return RaftTaskUtil.createTask(closure, raftSyncMsg, completableFuture);
    }

    @Override
    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        BranchTransactionDTO branchTransactionDTO = new BranchTransactionDTO();
        branchTransactionDTO.setBranchId(branchSession.getBranchId());
        branchTransactionDTO.setXid(branchSession.getXid());
        RaftBranchSessionSyncMsg raftSyncMsg = new RaftBranchSessionSyncMsg(RaftSyncMsgType.RELEASE_BRANCH_SESSION_LOCK, branchTransactionDTO);
        Closure closure = status -> {
            if (status.isOk()) {
                try {
                    completableFuture.complete(super.releaseLock(branchSession));
                }
                catch (TransactionException e) {
                    completableFuture.completeExceptionally(e);
                }
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + status.getErrorMsg()));
            }
        };
        return RaftTaskUtil.createTask(closure, raftSyncMsg, completableFuture);
    }

    public boolean localReleaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        return super.releaseGlobalSessionLock(globalSession);
    }

    public boolean localReleaseLock(BranchSession branchSession) throws TransactionException {
        return super.releaseLock(branchSession);
    }
}

