/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.core.exception.BranchTransactionException;
import io.seata.core.exception.GlobalTransactionException;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.LockStatus;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManager
implements SessionManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSessionManager.class);
    protected TransactionStoreManager transactionStoreManager;
    protected String name;

    public AbstractSessionManager() {
    }

    public AbstractSessionManager(String name) {
        this.name = name;
    }

    @Override
    public void addGlobalSession(GlobalSession session) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_ADD});
        }
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_ADD, session);
    }

    @Override
    public void updateGlobalSessionStatus(GlobalSession session, GlobalStatus status) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_UPDATE});
        }
        if (GlobalStatus.Rollbacking == status || GlobalStatus.TimeoutRollbacking == status) {
            session.getBranchSessions().forEach(i -> i.setLockStatus(LockStatus.Rollbacking));
        }
        session.setStatus(status);
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_UPDATE, session);
    }

    @Override
    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_REMOVE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_REMOVE, session);
    }

    @Override
    public void addBranchSession(GlobalSession session, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_ADD});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_ADD, branchSession);
    }

    @Override
    public void updateBranchSessionStatus(BranchSession branchSession, BranchStatus status) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_UPDATE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_UPDATE, branchSession);
    }

    @Override
    public void removeBranchSession(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_REMOVE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_REMOVE, branchSession);
    }

    @Override
    public void onBegin(GlobalSession globalSession) throws TransactionException {
        this.addGlobalSession(globalSession);
    }

    @Override
    public void onStatusChange(GlobalSession globalSession, GlobalStatus status) throws TransactionException {
        this.updateGlobalSessionStatus(globalSession, status);
    }

    @Override
    public void onBranchStatusChange(GlobalSession globalSession, BranchSession branchSession, BranchStatus status) throws TransactionException {
        branchSession.setStatus(status);
        this.updateBranchSessionStatus(branchSession, status);
    }

    @Override
    public void onAddBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        this.addBranchSession(globalSession, branchSession);
    }

    @Override
    public void onRemoveBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        this.removeBranchSession(globalSession, branchSession);
    }

    @Override
    public void onClose(GlobalSession globalSession) throws TransactionException {
        globalSession.setActive(false);
    }

    @Override
    public void onSuccessEnd(GlobalSession globalSession) throws TransactionException {
        this.removeGlobalSession(globalSession);
    }

    @Override
    public void onFailEnd(GlobalSession globalSession) throws TransactionException {
        LOGGER.info("xid:{} fail end, transaction:{}", (Object)globalSession.getXid(), (Object)globalSession);
    }

    private void writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable sessionStorable) throws TransactionException {
        if (!this.transactionStoreManager.writeSession(logOperation, sessionStorable)) {
            if (TransactionStoreManager.LogOperation.GLOBAL_ADD.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store global session");
            }
            if (TransactionStoreManager.LogOperation.GLOBAL_UPDATE.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to update global session");
            }
            if (TransactionStoreManager.LogOperation.GLOBAL_REMOVE.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to remove global session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_ADD.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store branch session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_UPDATE.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to update branch session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_REMOVE.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to remove branch session");
            }
            throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Unknown LogOperation:" + logOperation.name());
        }
    }

    public void destroy() {
    }

    public void setTransactionStoreManager(TransactionStoreManager transactionStoreManager) {
        this.transactionStoreManager = transactionStoreManager;
    }
}

