/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.sync.msg.dto;

import io.seata.common.metadata.Node;
import io.seata.common.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RaftClusterMetadata
implements Serializable {
    private static final long serialVersionUID = 6208583637662412658L;
    private Node leader;
    private List<Node> followers;
    private List<Node> learner;
    private long term;

    public RaftClusterMetadata() {
    }

    public RaftClusterMetadata(long term) {
        this.term = term;
    }

    public Node createNode(String host, int txPort, int controlPort, String group, Map<String, Object> metadata) {
        Node node = new Node();
        node.setTransaction(node.createEndpoint(host, txPort, "seata"));
        node.setControl(node.createEndpoint(host, controlPort, "http"));
        node.setGroup(group);
        Optional.ofNullable(metadata).ifPresent(arg_0 -> ((Node)node).setMetadata(arg_0));
        return node;
    }

    public Node getLeader() {
        return this.leader;
    }

    public void setLeader(Node leader) {
        this.leader = leader;
    }

    public long getTerm() {
        return this.term;
    }

    public List<Node> getFollowers() {
        return this.followers;
    }

    public void setFollowers(List<Node> followers) {
        this.followers = followers;
    }

    public List<Node> getLearner() {
        return this.learner;
    }

    public void setLearner(List<Node> learner) {
        this.learner = learner;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public String toString() {
        return StringUtils.toString((Object)this);
    }
}

