/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.snapshot.session;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import io.seata.server.cluster.raft.snapshot.RaftSnapshot;
import io.seata.server.cluster.raft.snapshot.StoreSnapshotFile;
import io.seata.server.cluster.raft.snapshot.session.RaftSessionSnapshot;
import io.seata.server.lock.LockerManagerFactory;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.raft.session.RaftSessionManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSnapshotFile
implements Serializable,
StoreSnapshotFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionSnapshotFile.class);
    private static final long serialVersionUID = 7942307427240595916L;
    String group;
    String fileName = "session";

    public SessionSnapshotFile(String group) {
        this.group = group;
    }

    @Override
    public Status save(SnapshotWriter writer) {
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(this.group);
        Map<String, GlobalSession> sessionMap = raftSessionManager.getSessionMap();
        RaftSessionSnapshot sessionSnapshot = new RaftSessionSnapshot();
        sessionMap.forEach((xid, session) -> sessionSnapshot.convert2GlobalSessionByte((GlobalSession)session));
        RaftSnapshot raftSnapshot = new RaftSnapshot();
        raftSnapshot.setBody(sessionSnapshot);
        raftSnapshot.setType(RaftSnapshot.SnapshotType.session);
        LOGGER.info("groupId: {}, global session size: {}", (Object)this.group, (Object)sessionSnapshot.getGlobalsessions().size());
        String path = writer.getPath() + File.separator + this.fileName;
        try {
            if (this.save(raftSnapshot, path)) {
                if (writer.addFile(this.fileName)) {
                    return Status.OK();
                }
                return new Status(RaftError.EIO, "Fail to add file to writer", new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Fail to save groupId: {} snapshot {}", new Object[]{this.group, path, e});
        }
        return new Status(RaftError.EIO, "Fail to save groupId: " + this.group + " snapshot %s", new Object[]{path});
    }

    @Override
    public boolean load(SnapshotReader reader) {
        if (reader.getFileMeta(this.fileName) == null) {
            LOGGER.error("Fail to find data file in {}", (Object)reader.getPath());
            return false;
        }
        String path = reader.getPath() + File.separator + this.fileName;
        try {
            LOGGER.info("on snapshot load start index: {}", (Object)reader.load().getLastIncludedIndex());
            RaftSessionSnapshot sessionSnapshot = (RaftSessionSnapshot)this.load(path);
            RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(this.group);
            Map<String, GlobalSession> rootSessionMap = raftSessionManager.getSessionMap();
            LockerManagerFactory.getLockManager().cleanAllLocks();
            rootSessionMap.clear();
            rootSessionMap.putAll(sessionSnapshot.convert2GlobalSession());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("on snapshot load end index: {}", (Object)reader.load().getLastIncludedIndex());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to load snapshot from {}", (Object)path, (Object)e);
            return false;
        }
    }
}

