/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.RaftServiceFactory;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.cli.CliClientServiceImpl;
import com.alipay.sofa.jraft.util.Endpoint;
import io.seata.common.XID;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.Disposable;
import io.seata.discovery.registry.FileRegistryServiceImpl;
import io.seata.discovery.registry.MultiRegistryFactory;
import io.seata.discovery.registry.RegistryService;
import io.seata.server.cluster.raft.RaftServer;
import io.seata.server.cluster.raft.RaftStateMachine;
import io.seata.server.store.StoreConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerFactory
implements Disposable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftServerFactory.class);
    private static final Map<String, RaftServer> RAFT_SERVER_MAP = new HashMap<String, RaftServer>();
    private Boolean raftMode = false;
    private RpcServer rpcServer;
    private static final io.seata.config.Configuration CONFIG = ConfigurationFactory.getInstance();

    public static RaftServerFactory getInstance() {
        return SingletonHandler.INSTANCE;
    }

    public static CliService getCliServiceInstance() {
        return SingletonHandler.CLI_SERVICE;
    }

    public static CliClientService getCliClientServiceInstance() {
        return SingletonHandler.CLI_CLIENT_SERVICE;
    }

    public void init() {
        String initConfStr = CONFIG.getConfig("server.raft.serverAddr");
        StoreConfig.SessionMode storeMode = StoreConfig.getSessionMode();
        this.raftMode = storeMode.equals((Object)StoreConfig.SessionMode.RAFT);
        if (StringUtils.isBlank((String)initConfStr)) {
            if (this.raftMode.booleanValue()) {
                throw new IllegalArgumentException("Raft store mode must config: server.raft.serverAddr");
            }
            return;
        }
        if (this.raftMode.booleanValue()) {
            for (RegistryService instance : MultiRegistryFactory.getInstances()) {
                if (instance instanceof FileRegistryServiceImpl) continue;
                throw new IllegalArgumentException("Raft store mode not support other Registration Center");
            }
        }
        LOGGER.warn("raft mode and raft cluster is an experimental feature");
        Configuration initConf = new Configuration();
        if (!initConf.parse(initConfStr)) {
            throw new IllegalArgumentException("fail to parse initConf:" + initConfStr);
        }
        int port = Integer.parseInt(System.getProperty("server.raftPort", "0"));
        PeerId serverId = null;
        String host = XID.getIpAddress();
        if (port <= 0) {
            for (PeerId peer : initConf.getPeers()) {
                if (!StringUtils.equals((String)peer.getIp(), (String)host)) continue;
                if (serverId != null) {
                    throw new IllegalArgumentException("server.raft.cluster has duplicate ip, For local debugging, use -Dserver.raftPort to specify the raft port");
                }
                serverId = peer;
            }
        } else {
            serverId = new PeerId(host, port);
        }
        String dataPath = CONFIG.getConfig("store.file.dir", "sessionStore") + File.separator + "raft" + File.separator + serverId.getPort();
        String group = CONFIG.getConfig("server.raft.group", "default");
        try {
            this.rpcServer = RaftRpcServerFactory.createRaftRpcServer((Endpoint)serverId.getEndpoint());
            RaftServer raftServer = new RaftServer(dataPath, group, serverId, this.initNodeOptions(initConf), this.rpcServer);
            RAFT_SERVER_MAP.put(group, raftServer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("fail init raft cluster:" + e.getMessage(), e);
        }
    }

    public void start() {
        RAFT_SERVER_MAP.forEach((group, raftServer) -> {
            try {
                raftServer.start();
            }
            catch (IOException e) {
                LOGGER.error("start seata server raft cluster error, group: {} ", group, (Object)e);
                throw new RuntimeException(e);
            }
            LOGGER.info("started seata server raft cluster, group: {} ", group);
        });
        if (!this.rpcServer.init(null)) {
            throw new RuntimeException("start raft node fail!");
        }
    }

    public void destroy() {
        this.close();
        this.rpcServer = null;
        this.raftMode = false;
    }

    @Override
    public void close() {
        RAFT_SERVER_MAP.forEach((group, raftServer) -> {
            raftServer.close();
            LOGGER.info("closed seata server raft cluster, group: {} ", group);
        });
        Optional.ofNullable(this.rpcServer).ifPresent(Lifecycle::shutdown);
        RAFT_SERVER_MAP.clear();
    }

    public RaftServer getRaftServer(String group) {
        return RAFT_SERVER_MAP.get(group);
    }

    public Collection<RaftServer> getRaftServers() {
        return RAFT_SERVER_MAP.values();
    }

    public Boolean isLeader(String group) {
        AtomicReference stateMachine = new AtomicReference();
        Optional.ofNullable(RAFT_SERVER_MAP.get(group)).ifPresent(raftServer -> stateMachine.set(raftServer.getRaftStateMachine()));
        RaftStateMachine raftStateMachine = (RaftStateMachine)((Object)stateMachine.get());
        return this.isRaftMode() == false && RAFT_SERVER_MAP.isEmpty() || raftStateMachine != null && raftStateMachine.isLeader();
    }

    public Boolean isRaftMode() {
        return this.raftMode;
    }

    private RaftOptions initRaftOptions() {
        RaftOptions raftOptions = new RaftOptions();
        raftOptions.setApplyBatch(CONFIG.getInt("server.raft.applyBatch", raftOptions.getApplyBatch()));
        raftOptions.setMaxAppendBufferSize(CONFIG.getInt("server.raft.maxAppendBufferSize", raftOptions.getMaxAppendBufferSize()));
        raftOptions.setDisruptorBufferSize(CONFIG.getInt("server.raft.disruptorBufferSize", raftOptions.getDisruptorBufferSize()));
        raftOptions.setMaxReplicatorInflightMsgs(CONFIG.getInt("server.raft.maxReplicatorInflightMsgs", raftOptions.getMaxReplicatorInflightMsgs()));
        raftOptions.setSync(CONFIG.getBoolean("server.raft.sync", raftOptions.isSync()));
        return raftOptions;
    }

    private NodeOptions initNodeOptions(Configuration initConf) {
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setDisableCli(false);
        int snapshotInterval = CONFIG.getInt("server.raft.snapshotInterval", 600);
        nodeOptions.setSnapshotIntervalSecs(snapshotInterval);
        nodeOptions.setRaftOptions(this.initRaftOptions());
        nodeOptions.setElectionTimeoutMs(CONFIG.getInt("server.raft.electionTimeoutMs", 1000));
        nodeOptions.setInitialConf(initConf);
        return nodeOptions;
    }

    public static Set<String> groups() {
        return RAFT_SERVER_MAP.keySet();
    }

    private static class SingletonHandler {
        private static final RaftServerFactory INSTANCE = new RaftServerFactory();
        private static final CliService CLI_SERVICE = RaftServiceFactory.createAndInitCliService((CliOptions)new CliOptions());
        private static final CliClientService CLI_CLIENT_SERVICE = new CliClientServiceImpl();

        private SingletonHandler() {
        }

        static {
            CLI_CLIENT_SERVICE.init((Object)new CliOptions());
        }
    }
}

