/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.config.FileConfigFactory;
import io.seata.config.file.FileConfig;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfiguration.class);
    private FileConfig fileConfig;
    private ExecutorService configOperateExecutor;
    private static final int CORE_CONFIG_OPERATE_THREAD = 1;
    private static final int MAX_CONFIG_OPERATE_THREAD = 2;
    private static final long LISTENER_CONFIG_INTERVAL = 1000L;
    private static final String REGISTRY_TYPE = "file";
    public static final String SYS_FILE_RESOURCE_PREFIX = "file:";
    private final ConcurrentMap<String, Set<ConfigurationChangeListener>> configListenersMap = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
    private final Map<String, String> listenedConfigMap = new HashMap<String, String>(8);
    private final String targetFilePath;
    private volatile long targetFileLastModified;
    private final String name;
    private final FileListener fileListener = new FileListener();
    private final boolean allowDynamicRefresh;

    public FileConfiguration() {
        this.name = null;
        this.targetFilePath = null;
        this.allowDynamicRefresh = false;
    }

    public FileConfiguration(String name) {
        this(name, true);
    }

    public FileConfiguration(String name, boolean allowDynamicRefresh) {
        File file = this.getConfigFile(name);
        if (file == null) {
            this.targetFilePath = null;
            this.fileConfig = FileConfigFactory.load();
            this.allowDynamicRefresh = false;
        } else {
            this.targetFilePath = file.getPath();
            this.fileConfig = FileConfigFactory.load(file, name);
            this.targetFileLastModified = new File(this.targetFilePath).lastModified();
            this.allowDynamicRefresh = allowDynamicRefresh;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The file name of the operation is {}", (Object)name);
            }
        }
        this.name = name;
        this.configOperateExecutor = new ThreadPoolExecutor(1, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("configOperate", 2));
    }

    private File getConfigFile(String name) {
        try {
            if (name == null) {
                throw new IllegalArgumentException("name can't be null");
            }
            boolean filePathCustom = name.startsWith(SYS_FILE_RESOURCE_PREFIX);
            String filePath = filePathCustom ? name.substring(SYS_FILE_RESOURCE_PREFIX.length()) : name;
            String decodedPath = URLDecoder.decode(filePath, StandardCharsets.UTF_8.name());
            File targetFile = this.getFileFromFileSystem(decodedPath);
            if (targetFile != null) {
                return targetFile;
            }
            if (!filePathCustom && (targetFile = this.getFileFromClasspath(name)) != null) {
                return targetFile;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("decode name error: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private File getFileFromFileSystem(String decodedPath) {
        URL resourceUrl = this.getClass().getClassLoader().getResource("");
        String[] tryPaths = null;
        tryPaths = resourceUrl != null ? new String[]{resourceUrl.getPath() + decodedPath, decodedPath} : new String[]{decodedPath};
        for (String tryPath : tryPaths) {
            File targetFile = new File(tryPath);
            if (targetFile.exists()) {
                return targetFile;
            }
            for (String s : FileConfigFactory.getSuffixSet()) {
                targetFile = new File(tryPath + "." + s);
                if (!targetFile.exists()) continue;
                return targetFile;
            }
        }
        return null;
    }

    private File getFileFromClasspath(String name) throws UnsupportedEncodingException {
        URL resource = this.getClass().getClassLoader().getResource(name);
        if (resource == null) {
            for (String s : FileConfigFactory.getSuffixSet()) {
                resource = this.getClass().getClassLoader().getResource(name + "." + s);
                if (resource == null) continue;
                String path = resource.getPath();
                path = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
                return new File(path);
            }
        } else {
            String path = resource.getPath();
            path = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
            return new File(path);
        }
        return null;
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSys(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        Object getValue = configFuture.get();
        return getValue == null ? null : String.valueOf(getValue);
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        this.configListenersMap.computeIfAbsent(dataId, key -> ConcurrentHashMap.newKeySet()).add(listener);
        this.listenedConfigMap.put(dataId, ConfigurationFactory.getInstance().getConfig(dataId));
        this.fileListener.addListener(dataId, listener);
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            configListeners.remove(listener);
            if (configListeners.isEmpty()) {
                this.configListenersMap.remove(dataId);
                this.listenedConfigMap.remove(dataId);
            }
        }
        listener.onShutDown();
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)this.configListenersMap.get(dataId);
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    public FileConfig getFileConfig() {
        return this.fileConfig;
    }

    class FileListener
    implements ConfigurationChangeListener {
        private final Map<String, Set<ConfigurationChangeListener>> dataIdMap = new HashMap<String, Set<ConfigurationChangeListener>>();
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fileListener", 1));

        FileListener() {
        }

        public synchronized void addListener(String dataId, ConfigurationChangeListener listener) {
            if (this.dataIdMap.isEmpty()) {
                FileConfiguration.this.fileListener.onProcessEvent(new ConfigurationChangeEvent());
            }
            this.dataIdMap.computeIfAbsent(dataId, value -> new HashSet()).add(listener);
        }

        @Override
        public void onChangeEvent(ConfigurationChangeEvent event) {
            Boolean enabled = Boolean.valueOf(System.getProperty("file.listener.enabled", "true"));
            while (enabled.booleanValue()) {
                for (String dataId : this.dataIdMap.keySet()) {
                    try {
                        String oldConfig;
                        String currentConfig = ConfigurationFactory.getInstance().getLatestConfig(dataId, null, 5000L);
                        if (!StringUtils.isNotBlank((String)currentConfig) || !ObjectUtils.notEqual((Object)currentConfig, (Object)(oldConfig = (String)FileConfiguration.this.listenedConfigMap.get(dataId)))) continue;
                        FileConfiguration.this.listenedConfigMap.put(dataId, currentConfig);
                        event.setDataId(dataId).setNewValue(currentConfig).setOldValue(oldConfig);
                        for (ConfigurationChangeListener listener : this.dataIdMap.get(dataId)) {
                            listener.onChangeEvent(event);
                        }
                    }
                    catch (Exception exx) {
                        LOGGER.error("fileListener execute error, dataId :{}", (Object)dataId, (Object)exx);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("fileListener thread sleep error:{}", (Object)e.getMessage());
                }
                enabled = Boolean.valueOf(System.getProperty("file.listener.enabled", "true"));
            }
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executor;
        }
    }

    class ConfigOperateRunnable
    implements Runnable {
        private ConfigFuture configFuture;

        public ConfigOperateRunnable(ConfigFuture configFuture) {
            this.configFuture = configFuture;
        }

        @Override
        public void run() {
            block12: {
                if (this.configFuture != null) {
                    if (this.configFuture.isTimeout()) {
                        this.setFailResult(this.configFuture);
                        return;
                    }
                    try {
                        FileConfig tempConfig;
                        long tempLastModified;
                        if (FileConfiguration.this.allowDynamicRefresh && (tempLastModified = new File(FileConfiguration.this.targetFilePath).lastModified()) > FileConfiguration.this.targetFileLastModified && (tempConfig = FileConfigFactory.load(new File(FileConfiguration.this.targetFilePath), FileConfiguration.this.name)) != null) {
                            FileConfiguration.this.fileConfig = tempConfig;
                            FileConfiguration.this.targetFileLastModified = tempLastModified;
                        }
                        if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                            String result = FileConfiguration.this.fileConfig.getString(this.configFuture.getDataId());
                            this.configFuture.setResult(result);
                        } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUT) {
                            this.configFuture.setResult(Boolean.TRUE);
                        } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUTIFABSENT) {
                            this.configFuture.setResult(Boolean.TRUE);
                        } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.REMOVE) {
                            this.configFuture.setResult(Boolean.TRUE);
                        }
                    }
                    catch (Exception e) {
                        this.setFailResult(this.configFuture);
                        if (!LOGGER.isDebugEnabled()) break block12;
                        LOGGER.debug("Could not found property {}, try to use default value instead. exception:{}", (Object)this.configFuture.getDataId(), (Object)e.getMessage());
                    }
                }
            }
        }

        private void setFailResult(ConfigFuture configFuture) {
            if (configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                String result = configFuture.getContent();
                configFuture.setResult(result);
            } else {
                configFuture.setResult(Boolean.FALSE);
            }
        }
    }
}

