/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.EnhancedServiceNotFoundException;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationProvider;
import io.seata.config.ExtConfigurationProvider;
import io.seata.config.FileConfiguration;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String REGISTRY_CONF_DEFAULT = "registry";
    private static final String ENV_SYSTEM_KEY = "SEATA_ENV";
    public static final String ENV_PROPERTY_KEY = "seataEnv";
    private static final String SYSTEM_PROPERTY_SEATA_CONFIG_NAME = "seata.config.name";
    private static final String ENV_SEATA_CONFIG_NAME = "SEATA_CONFIG_NAME";
    public static volatile Configuration CURRENT_FILE_INSTANCE;
    public static volatile FileConfiguration ORIGIN_FILE_INSTANCE_REGISTRY;
    public static volatile FileConfiguration ORIGIN_FILE_INSTANCE;
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";
    private static volatile Configuration instance;

    private static void load() {
        FileConfiguration configuration = ORIGIN_FILE_INSTANCE_REGISTRY;
        Configuration extConfiguration = null;
        try {
            extConfiguration = ((ExtConfigurationProvider)EnhancedServiceLoader.load(ExtConfigurationProvider.class)).provide(configuration);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("load Configuration from :{}", (Object)(extConfiguration == null ? configuration.getClass().getSimpleName() : "Spring Configuration"));
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("failed to load extConfiguration: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to load extConfiguration: {}", (Object)e.getMessage(), (Object)e);
        }
        CURRENT_FILE_INSTANCE = extConfiguration == null ? configuration : extConfiguration;
    }

    private static void initOriginConfiguraction() {
        String envValue;
        String seataConfigName = System.getProperty(SYSTEM_PROPERTY_SEATA_CONFIG_NAME);
        if (seataConfigName == null) {
            seataConfigName = System.getenv(ENV_SEATA_CONFIG_NAME);
        }
        if (seataConfigName == null) {
            seataConfigName = REGISTRY_CONF_DEFAULT;
        }
        if ((envValue = System.getProperty(ENV_PROPERTY_KEY)) == null) {
            envValue = System.getenv(ENV_SYSTEM_KEY);
        }
        seataConfigName = envValue == null ? seataConfigName : seataConfigName + "-" + envValue;
        ORIGIN_FILE_INSTANCE_REGISTRY = new FileConfiguration(seataConfigName, false);
    }

    public static FileConfiguration getOriginFileInstanceRegistry() {
        return ORIGIN_FILE_INSTANCE_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (instance != null) return instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (instance != null) return instance;
            instance = ConfigurationFactory.buildConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void maybeNeedOriginFileInstance() {
        if (ConfigType.File == ConfigurationFactory.getConfigType()) {
            String pathDataId = String.join((CharSequence)".", "config", FILE_TYPE, NAME_KEY);
            String name = CURRENT_FILE_INSTANCE.getConfig(pathDataId);
            ORIGIN_FILE_INSTANCE = new FileConfiguration(name);
        }
    }

    private static ConfigType getConfigType() {
        String configTypeName = CURRENT_FILE_INSTANCE.getConfig("config.type");
        if (StringUtils.isBlank((String)configTypeName)) {
            throw new NotSupportYetException("config type can not be null");
        }
        return ConfigType.getType(configTypeName);
    }

    public static Optional<FileConfiguration> getOriginFileInstance() {
        return Optional.ofNullable(ORIGIN_FILE_INSTANCE);
    }

    private static Configuration buildConfiguration() {
        ConfigType configType = ConfigurationFactory.getConfigType();
        Configuration extConfiguration = null;
        Configuration configuration = ORIGIN_FILE_INSTANCE;
        if (configuration != null) {
            try {
                extConfiguration = ((ExtConfigurationProvider)EnhancedServiceLoader.load(ExtConfigurationProvider.class)).provide(configuration);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("load Configuration from :{}", (Object)(extConfiguration == null ? configuration.getClass().getSimpleName() : "Spring Configuration"));
                }
            }
            catch (EnhancedServiceNotFoundException enhancedServiceNotFoundException) {
            }
            catch (Exception e) {
                LOGGER.error("failed to load extConfiguration:{}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            configuration = ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)Objects.requireNonNull(configType).name())).provide();
        }
        try {
            Configuration configurationCache = null != extConfiguration ? ConfigurationCache.getInstance().proxy(extConfiguration) : ConfigurationCache.getInstance().proxy(configuration);
            if (null != configurationCache) {
                extConfiguration = configurationCache;
            }
        }
        catch (EnhancedServiceNotFoundException configurationCache) {
        }
        catch (Exception e) {
            LOGGER.error("failed to load configurationCacheProvider:{}", (Object)e.getMessage(), (Object)e);
        }
        return null == extConfiguration ? configuration : extConfiguration;
    }

    protected static void reload() {
        ConfigurationCache.clear();
        ConfigurationFactory.initOriginConfiguraction();
        ConfigurationFactory.load();
        ConfigurationFactory.maybeNeedOriginFileInstance();
        instance = null;
        ConfigurationFactory.getInstance();
    }

    static {
        ORIGIN_FILE_INSTANCE = null;
        ConfigurationFactory.initOriginConfiguraction();
        ConfigurationFactory.load();
        ConfigurationFactory.maybeNeedOriginFileInstance();
        instance = null;
    }
}

