/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.sort;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class Sort {
    private String field;
    private Sorting order;
    private Object missing;
    private Boolean unmapped;
    private String unmappedType;

    public Sort(String field) {
        this.field = field;
    }

    public Sort(String field, Sorting order) {
        this.field = field;
        this.order = order;
    }

    public void setMissing(Object m) {
        this.missing = m;
    }

    public void setIgnoreUnmapped() {
        this.unmapped = true;
    }

    public void setUnmappedType(String unmappedType) {
        this.unmappedType = unmappedType;
    }

    public JsonObject toJsonObject() {
        JsonObject sortDefinition = new JsonObject();
        if (this.order != null) {
            sortDefinition.add("order", new JsonPrimitive(this.order.toString()));
        }
        if (this.missing != null) {
            sortDefinition.add("missing", new JsonPrimitive(this.missing.toString()));
        }
        if (this.unmapped != null) {
            sortDefinition.add("ignore_unmapped", new JsonPrimitive(this.unmapped));
        }
        if (this.unmappedType != null) {
            sortDefinition.add("unmapped_type", new JsonPrimitive(this.unmappedType));
        }
        JsonObject sortObject = new JsonObject();
        sortObject.add(this.field, sortDefinition);
        return sortObject;
    }

    public static enum Missing {
        LAST("_last"),
        FIRST("_first");

        private final String name;

        private Missing(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Sorting {
        ASC("asc"),
        DESC("desc");

        private final String name;

        private Sorting(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

