/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PercentileRanksAggregation
extends MetricAggregation {
    public static final String TYPE = "percentile_ranks";
    private Map<String, Double> percentileRanks = new HashMap<String, Double>();

    public PercentileRanksAggregation(String name, JsonObject percentilesAggregation) {
        super(name, percentilesAggregation);
        this.parseSource(percentilesAggregation.getAsJsonObject(String.valueOf((Object)AggregationField.VALUES)));
    }

    private void parseSource(JsonObject source) {
        for (Map.Entry<String, JsonElement> entry : source.entrySet()) {
            if (Double.isNaN(entry.getValue().getAsDouble())) continue;
            this.percentileRanks.put(entry.getKey(), entry.getValue().getAsDouble());
        }
    }

    public Map<String, Double> getPercentileRanks() {
        return this.percentileRanks;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PercentileRanksAggregation rhs = (PercentileRanksAggregation)obj;
        return super.equals(obj) && Objects.equals(this.percentileRanks, rhs.percentileRanks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.percentileRanks);
    }
}

