/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.annotations.VisibleForTesting;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SearchScroll
extends GenericResultAbstractAction {
    @VisibleForTesting
    static final int MAX_SCROLL_ID_LENGTH = 1900;
    private final String restMethodName;

    protected SearchScroll(Builder builder) {
        super(builder);
        if (builder.getScrollId().length() > 1900) {
            this.restMethodName = "POST";
            this.payload = builder.getScrollId();
        } else {
            this.restMethodName = "GET";
        }
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_search/scroll";
    }

    @Override
    public String getRestMethodName() {
        return this.restMethodName;
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SearchScroll rhs = (SearchScroll)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).isEquals();
    }

    public static class Builder
    extends AbstractMultiIndexActionBuilder<SearchScroll, Builder> {
        private final String scrollId;

        public Builder(String scrollId, String scroll) {
            this.scrollId = scrollId;
            if (scrollId.length() <= 1900) {
                this.setParameter("scroll_id", scrollId);
            }
            this.setParameter("scroll", scroll);
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return StringUtils.join((Iterable)this.indexNames, (String)",");
            }
            return null;
        }

        @Override
        public SearchScroll build() {
            return new SearchScroll(this);
        }

        public String getScrollId() {
            return this.scrollId;
        }
    }
}

