/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.RoundRobinServerList;
import io.searchbox.client.config.ServerList;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.exception.NoServerConfiguredException;
import io.searchbox.client.util.PaddedAtomicReference;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(AbstractJestClient.class);
    public static final String ELASTIC_SEARCH_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ssZ";
    private final PaddedAtomicReference<ServerList> listOfServers = new PaddedAtomicReference();
    protected Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'hh:mm:ssZ").create();
    private NodeChecker nodeChecker;

    public void setNodeChecker(NodeChecker nodeChecker) {
        this.nodeChecker = nodeChecker;
    }

    public LinkedHashSet<String> getServers() {
        ServerList server = (ServerList)this.listOfServers.get();
        if (server != null) {
            return new LinkedHashSet<String>(server.getServers());
        }
        return null;
    }

    public void setServers(ServerList list) {
        this.listOfServers.set(list);
    }

    @Override
    public void setServers(Set<String> servers) {
        try {
            RoundRobinServerList serverList = new RoundRobinServerList(servers);
            this.listOfServers.set(serverList);
        }
        catch (NoServerConfiguredException noServers) {
            this.listOfServers.set(null);
            log.warn("No servers are currently available for the client to talk to.");
        }
    }

    @Override
    public void shutdownClient() {
        if (null != this.nodeChecker) {
            this.nodeChecker.stopAsync();
            this.nodeChecker.awaitTerminated();
        }
    }

    protected String getElasticSearchServer() {
        ServerList serverList = (ServerList)this.listOfServers.get();
        if (serverList != null) {
            return serverList.getServer();
        }
        throw new NoServerConfiguredException("No Server is assigned to client to connect");
    }

    protected String getRequestURL(String elasticSearchServer, String uri) {
        StringBuilder sb = new StringBuilder(elasticSearchServer);
        if (uri.length() > 0 && uri.charAt(0) == '/') {
            sb.append(uri);
        } else {
            sb.append('/').append(uri);
        }
        return sb.toString();
    }
}

