/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaksTrackingByteBufAllocator
implements ByteBufAllocator {
    static final Logger LOGGER = LoggerFactory.getLogger(LeaksTrackingByteBufAllocator.class);
    final ConcurrentLinkedQueue<ByteBuf> tracker = new ConcurrentLinkedQueue();
    final ByteBufAllocator delegate;
    final Duration awaitZeroRefCntDuration;
    final String tag;
    static final Class<?> simpleLeakAwareCompositeByteBufClass;
    static final Field leakFieldForComposite;
    static final Class<?> simpleLeakAwareByteBufClass;
    static final Field leakFieldForNormal;
    static final Field allLeaksField;

    public static LeaksTrackingByteBufAllocator instrument(ByteBufAllocator allocator) {
        return new LeaksTrackingByteBufAllocator(allocator, Duration.ZERO, "");
    }

    public static LeaksTrackingByteBufAllocator instrument(ByteBufAllocator allocator, Duration awaitZeroRefCntDuration, String tag) {
        return new LeaksTrackingByteBufAllocator(allocator, awaitZeroRefCntDuration, tag);
    }

    private LeaksTrackingByteBufAllocator(ByteBufAllocator delegate, Duration awaitZeroRefCntDuration, String tag) {
        this.delegate = delegate;
        this.awaitZeroRefCntDuration = awaitZeroRefCntDuration;
        this.tag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaksTrackingByteBufAllocator assertHasNoLeaks() {
        try {
            ArrayList<ByteBuf> unreleased = new ArrayList<ByteBuf>();
            for (ByteBuf bb2 : this.tracker) {
                if (bb2.refCnt() == 0) continue;
                unreleased.add(bb2);
            }
            Duration awaitZeroRefCntDuration = this.awaitZeroRefCntDuration;
            if (!unreleased.isEmpty() && !awaitZeroRefCntDuration.isZero()) {
                long startTime = System.currentTimeMillis();
                long endTimeInMillis = startTime + awaitZeroRefCntDuration.toMillis();
                while (System.currentTimeMillis() <= endTimeInMillis) {
                    boolean hasUnreleased = false;
                    for (ByteBuf bb3 : unreleased) {
                        if (bb3.refCnt() == 0) continue;
                        hasUnreleased = true;
                        break;
                    }
                    if (!hasUnreleased) {
                        LeaksTrackingByteBufAllocator leaksTrackingByteBufAllocator = this;
                        return leaksTrackingByteBufAllocator;
                    }
                    LOGGER.debug(this.tag + " await buffers to be released");
                    for (int i = 0; i < 100; ++i) {
                        System.gc();
                        LockSupport.parkNanos(1000L);
                        System.gc();
                    }
                }
            }
            HashSet<ByteBuf> collected = new HashSet<ByteBuf>();
            for (ByteBuf buf : unreleased) {
                if (buf.refCnt() == 0) continue;
                try {
                    collected.add(buf);
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            ((ListAssert)Assertions.assertThat(collected.stream().filter(bb -> bb.refCnt() != 0).peek(bb -> {
                try {
                    LOGGER.debug(this.tag + " " + LeaksTrackingByteBufAllocator.resolveTrackingInfo(bb));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            })).describedAs("[" + this.tag + "] all buffers expected to be released but got ", new Object[0])).isEmpty();
        }
        finally {
            this.tracker.clear();
        }
        return this;
    }

    public ByteBuf buffer() {
        return this.track(this.delegate.buffer());
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.track(this.delegate.buffer(initialCapacity));
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.buffer(initialCapacity, maxCapacity));
    }

    public ByteBuf ioBuffer() {
        return this.track(this.delegate.ioBuffer());
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.track(this.delegate.ioBuffer(initialCapacity));
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.ioBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf heapBuffer() {
        return this.track(this.delegate.heapBuffer());
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return this.track(this.delegate.heapBuffer(initialCapacity));
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.heapBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf directBuffer() {
        return this.track(this.delegate.directBuffer());
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.track(this.delegate.directBuffer(initialCapacity));
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.directBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeBuffer() {
        return this.track(this.delegate.compositeBuffer());
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.track(this.delegate.compositeHeapBuffer());
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.track(this.delegate.compositeDirectBuffer());
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeDirectBuffer(maxNumComponents));
    }

    public boolean isDirectBufferPooled() {
        return this.delegate.isDirectBufferPooled();
    }

    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return this.delegate.calculateNewCapacity(minNewCapacity, maxCapacity);
    }

    <T extends ByteBuf> T track(T buffer) {
        this.tracker.offer(buffer);
        return buffer;
    }

    static Set<Object> resolveTrackingInfo(ByteBuf byteBuf) throws Exception {
        if (ResourceLeakDetector.getLevel().ordinal() >= ResourceLeakDetector.Level.ADVANCED.ordinal()) {
            if (simpleLeakAwareCompositeByteBufClass.isInstance(byteBuf)) {
                return (Set)allLeaksField.get(leakFieldForComposite.get(byteBuf));
            }
            if (simpleLeakAwareByteBufClass.isInstance(byteBuf)) {
                return (Set)allLeaksField.get(leakFieldForNormal.get(byteBuf));
            }
        }
        return Collections.emptySet();
    }

    static {
        try {
            Class<?> aClass = Class.forName("io.netty.buffer.SimpleLeakAwareCompositeByteBuf");
            Field leakField = aClass.getDeclaredField("leak");
            leakField.setAccessible(true);
            simpleLeakAwareCompositeByteBufClass = aClass;
            leakFieldForComposite = leakField;
            aClass = Class.forName("io.netty.buffer.SimpleLeakAwareByteBuf");
            leakField = aClass.getDeclaredField("leak");
            leakField.setAccessible(true);
            simpleLeakAwareByteBufClass = aClass;
            leakFieldForNormal = leakField;
            aClass = Class.forName("io.netty.util.ResourceLeakDetector$DefaultResourceLeak");
            Field field = aClass.getDeclaredField("allLeaks");
            field.setAccessible(true);
            allLeaksField = field;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

