/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Closeable;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.core.RSocketServer;
import io.rsocket.test.SlowTest;
import io.rsocket.test.TestRSocket;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.util.DefaultPayload;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.test.StepVerifier;

public interface TransportTest {
    public static final String MOCK_DATA = "test-data";
    public static final String MOCK_METADATA = "metadata";
    public static final String LARGE_DATA = TransportTest.read("words.shakespeare.txt.gz");
    public static final Payload LARGE_PAYLOAD = DefaultPayload.create((CharSequence)LARGE_DATA, (CharSequence)LARGE_DATA);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(String resourceName) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(TransportTest.class.getClassLoader().getResourceAsStream(resourceName))));){
            String string = br.lines().map(String::toLowerCase).collect(Collectors.joining("\n\r"));
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @BeforeEach
    default public void setUp() {
        Hooks.onOperatorDebug();
    }

    @AfterEach
    default public void close() {
        this.getTransportPair().dispose();
        Hooks.resetOnOperatorDebug();
    }

    default public Payload createTestPayload(int metadataPresent) {
        String metadata1;
        switch (metadataPresent % 5) {
            case 0: {
                metadata1 = null;
                break;
            }
            case 1: {
                metadata1 = "";
                break;
            }
            default: {
                metadata1 = MOCK_METADATA;
            }
        }
        String metadata = metadata1;
        return DefaultPayload.create((CharSequence)MOCK_DATA, (CharSequence)metadata);
    }

    @DisplayName(value="makes 10 fireAndForget requests")
    @Test
    default public void fireAndForget10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().fireAndForget(this.createTestPayload((int)i))).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10 fireAndForget with Large Payload in Requests")
    @Test
    default public void largePayloadFireAndForget10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().fireAndForget(LARGE_PAYLOAD)).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    default public RSocket getClient() {
        return this.getTransportPair().getClient();
    }

    public Duration getTimeout();

    public TransportPair getTransportPair();

    @DisplayName(value="makes 10 metadataPush requests")
    @Test
    default public void metadataPush10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().metadataPush(DefaultPayload.create((CharSequence)"", (CharSequence)"test-metadata"))).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10 metadataPush with Large Metadata in requests")
    @Test
    default public void largePayloadMetadataPush10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().metadataPush(DefaultPayload.create((CharSequence)"", (CharSequence)LARGE_DATA))).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 0 payloads")
    @Test
    default public void requestChannel0() {
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)Flux.empty()).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 1 payloads")
    @Test
    default public void requestChannel1() {
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)Mono.just((Object)this.createTestPayload(0))).as(StepVerifier::create)).expectNextCount(1L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 200,000 payloads")
    @Test
    default public void requestChannel200_000() {
        Flux payloads = Flux.range((int)0, (int)200000).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(200000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 200 large payloads")
    @Test
    default public void largePayloadRequestChannel200() {
        Flux payloads = Flux.range((int)0, (int)200).map(__ -> LARGE_PAYLOAD);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(200L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 20,000 payloads")
    @Test
    default public void requestChannel20_000() {
        Flux payloads = Flux.range((int)0, (int)20000).map(metadataPresent -> this.createTestPayload(7));
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).doOnNext(this::assertChannelPayload).as(StepVerifier::create)).expectNextCount(20000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 2,000,000 payloads")
    @SlowTest
    default public void requestChannel2_000_000() {
        Flux payloads = Flux.range((int)0, (int)2000000).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(2000000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 3 payloads")
    @Test
    default public void requestChannel3() {
        AtomicLong requested = new AtomicLong();
        Flux payloads = Flux.range((int)0, (int)3).doOnRequest(requested::addAndGet).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(publisher -> StepVerifier.create((Publisher)publisher, (long)3L))).expectNextCount(3L).expectComplete().verify(this.getTimeout());
        Assertions.assertThat((long)requested.get()).isEqualTo(3L);
    }

    @DisplayName(value="makes 1 requestChannel request with 512 payloads")
    @Test
    default public void requestChannel512() {
        Flux payloads = Flux.range((int)0, (int)512).map(this::createTestPayload);
        Flux.range((int)0, (int)1024).flatMap(v -> Mono.fromRunnable(() -> this.check((Flux<Payload>)payloads)).subscribeOn(Schedulers.elastic()), 12).blockLast();
    }

    default public void check(Flux<Payload> payloads) {
        ((StepVerifier.FirstStep)this.getClient().requestChannel(payloads).as(StepVerifier::create)).expectNextCount(512L).as("expected 512 items").expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestResponse request")
    @Test
    default public void requestResponse1() {
        ((StepVerifier.FirstStep)this.getClient().requestResponse(this.createTestPayload(1)).doOnNext(this::assertPayload).as(StepVerifier::create)).expectNextCount(1L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10 requestResponse requests")
    @Test
    default public void requestResponse10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).doOnNext(v -> this.assertPayload((Payload)v))).as(StepVerifier::create)).expectNextCount(10L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 100 requestResponse requests")
    @Test
    default public void requestResponse100() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)100).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(100L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 100 requestResponse requests")
    @Test
    default public void largePayloadRequestResponse100() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)100).flatMap(i -> this.getClient().requestResponse(LARGE_PAYLOAD).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(100L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10,000 requestResponse requests")
    @Test
    default public void requestResponse10_000() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10000).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(10000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and receives 10,000 responses")
    @Test
    default public void requestStream10_000() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).doOnNext(this::assertPayload).as(StepVerifier::create)).expectNextCount(10000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and receives 5 responses")
    @Test
    default public void requestStream5() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).doOnNext(this::assertPayload).take(5L).as(StepVerifier::create)).expectNextCount(5L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and consumes result incrementally")
    @Test
    default public void requestStreamDelayedRequestN() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).take(10L).as(StepVerifier::create)).thenRequest(5L).expectNextCount(5L).thenRequest(5L).expectNextCount(5L).expectComplete().verify(this.getTimeout());
    }

    default public void assertPayload(Payload p) {
        TransportPair transportPair = this.getTransportPair();
        if (!transportPair.expectedPayloadData().equals(p.getDataUtf8()) || !transportPair.expectedPayloadMetadata().equals(p.getMetadataUtf8())) {
            throw new IllegalStateException("Unexpected payload");
        }
    }

    default public void assertChannelPayload(Payload p) {
        if (!MOCK_DATA.equals(p.getDataUtf8()) || !MOCK_METADATA.equals(p.getMetadataUtf8())) {
            throw new IllegalStateException("Unexpected payload");
        }
    }

    public static final class TransportPair<T, S extends Closeable>
    implements Disposable {
        private static final String data = "hello world";
        private static final String metadata = "metadata";
        private final RSocket client;
        private final S server;

        public TransportPair(Supplier<T> addressSupplier, BiFunction<T, S, ClientTransport> clientTransportSupplier, Function<T, ServerTransport<S>> serverTransportSupplier) {
            T address = addressSupplier.get();
            this.server = (Closeable)RSocketServer.create((setup, sendingSocket) -> Mono.just((Object)new TestRSocket(data, "metadata"))).bind(serverTransportSupplier.apply(address)).block();
            this.client = (RSocket)RSocketConnector.connectWith((ClientTransport)clientTransportSupplier.apply(address, this.server)).doOnError(Throwable::printStackTrace).block();
        }

        public void dispose() {
            this.server.dispose();
        }

        RSocket getClient() {
            return this.client;
        }

        public String expectedPayloadData() {
            return data;
        }

        public String expectedPayloadMetadata() {
            return "metadata";
        }
    }
}

