/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import io.rsocket.frame.CancelFrameCodec;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.ExtensionFrameCodec;
import io.rsocket.frame.KeepAliveFrameCodec;
import io.rsocket.frame.LeaseFrameCodec;
import io.rsocket.frame.MetadataPushFrameCodec;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestNFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import io.rsocket.frame.SetupFrameCodec;
import io.rsocket.util.DefaultPayload;
import io.rsocket.util.EmptyPayload;

public final class TestFrames {
    private static final ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
    private static final Payload emptyPayload = DefaultPayload.create((ByteBuf)Unpooled.EMPTY_BUFFER);

    private TestFrames() {
    }

    public static ByteBuf createTestCancelFrame() {
        return CancelFrameCodec.encode((ByteBufAllocator)allocator, (int)1);
    }

    public static ByteBuf createTestErrorFrame() {
        return ErrorFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (Throwable)new RuntimeException());
    }

    public static ByteBuf createTestExtensionFrame() {
        return ExtensionFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (int)1, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestKeepaliveFrame() {
        return KeepAliveFrameCodec.encode((ByteBufAllocator)allocator, (boolean)false, (long)1L, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestLeaseFrame() {
        return LeaseFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (int)1, null);
    }

    public static ByteBuf createTestMetadataPushFrame() {
        return MetadataPushFrameCodec.encode((ByteBufAllocator)allocator, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestPayloadFrame() {
        return PayloadFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (boolean)false, (boolean)true, (boolean)false, null, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestRequestChannelFrame() {
        return RequestChannelFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (boolean)false, (boolean)false, (long)1L, null, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestRequestFireAndForgetFrame() {
        return RequestFireAndForgetFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (boolean)false, null, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf createTestRequestNFrame() {
        return RequestNFrameCodec.encode((ByteBufAllocator)allocator, (int)1, (long)1L);
    }

    public static ByteBuf createTestRequestResponseFrame() {
        return RequestResponseFrameCodec.encodeReleasingPayload((ByteBufAllocator)allocator, (int)1, (Payload)emptyPayload);
    }

    public static ByteBuf createTestRequestStreamFrame() {
        return RequestStreamFrameCodec.encodeReleasingPayload((ByteBufAllocator)allocator, (int)1, (long)1L, (Payload)emptyPayload);
    }

    public static ByteBuf createTestSetupFrame() {
        return SetupFrameCodec.encode((ByteBufAllocator)allocator, (boolean)false, (int)1, (int)1, (ByteBuf)Unpooled.EMPTY_BUFFER, (String)"metadataType", (String)"dataType", (Payload)EmptyPayload.INSTANCE);
    }
}

