/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Payload;
import io.rsocket.test.ClientSetupRule;
import io.rsocket.test.CountdownBaseSubscriber;
import io.rsocket.util.DefaultPayload;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public abstract class BaseClientServerTest<T extends ClientSetupRule<?, ?>> {
    @Rule
    public final T setup = this.createClientServer();

    protected abstract T createClientServer();

    @Test(timeout=10000L)
    public void testFireNForget10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().fireAndForget(this.testPayload((int)i))).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)0L, (long)outputCount);
    }

    @Test(timeout=10000L)
    public void testPushMetadata10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().metadataPush(DefaultPayload.create((CharSequence)"", (CharSequence)"metadata"))).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)0L, (long)outputCount);
    }

    @Test
    public void testRequestResponse1() {
        long outputCount = (Long)Flux.range((int)1, (int)1).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)1L, (long)outputCount);
    }

    @Test(timeout=10000L)
    public void testRequestResponse10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)10L, (long)outputCount);
    }

    private Payload testPayload(int metadataPresent) {
        String metadata;
        switch (metadataPresent % 5) {
            case 0: {
                metadata = null;
                break;
            }
            case 1: {
                metadata = "";
                break;
            }
            default: {
                metadata = "metadata";
            }
        }
        return DefaultPayload.create((CharSequence)"hello", (CharSequence)metadata);
    }

    @Test(timeout=10000L)
    public void testRequestResponse100() {
        long outputCount = (Long)Flux.range((int)1, (int)100).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)100L, (long)outputCount);
    }

    @Test(timeout=20000L)
    public void testRequestResponse10_000() {
        long outputCount = (Long)Flux.range((int)1, (int)10000).flatMap(i -> ((ClientSetupRule)((Object)((Object)this.setup))).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assert.assertEquals((long)10000L, (long)outputCount);
    }

    @Test(timeout=10000L)
    public void testRequestStream() {
        Flux publisher = ((ClientSetupRule)((Object)this.setup)).getRSocket().requestStream(this.testPayload(3));
        long count = (Long)publisher.take(5L).count().block();
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test(timeout=10000L)
    public void testRequestStreamAll() {
        Flux publisher = ((ClientSetupRule)((Object)this.setup)).getRSocket().requestStream(this.testPayload(3));
        long count = (Long)publisher.count().block();
        Assert.assertEquals((long)10000L, (long)count);
    }

    @Test(timeout=10000L)
    public void testRequestStreamWithRequestN() {
        CountdownBaseSubscriber ts = new CountdownBaseSubscriber();
        ts.expect(5);
        ((ClientSetupRule)((Object)this.setup)).getRSocket().requestStream(this.testPayload(3)).subscribe((CoreSubscriber)ts);
        ts.await();
        Assert.assertEquals((long)5L, (long)ts.count());
        ts.expect(5);
        ts.await();
        ts.cancel();
        Assert.assertEquals((long)10L, (long)ts.count());
    }

    @Test(timeout=10000L)
    public void testRequestStreamWithDelayedRequestN() {
        CountdownBaseSubscriber ts = new CountdownBaseSubscriber();
        ((ClientSetupRule)((Object)this.setup)).getRSocket().requestStream(this.testPayload(3)).subscribe((CoreSubscriber)ts);
        ts.expect(5);
        ts.await();
        Assert.assertEquals((long)5L, (long)ts.count());
        ts.expect(5);
        ts.await();
        ts.cancel();
        Assert.assertEquals((long)10L, (long)ts.count());
    }

    @Test(timeout=10000L)
    public void testChannel0() {
        Flux publisher = ((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)Flux.empty());
        long count = (Long)publisher.count().block();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test(timeout=10000L)
    public void testChannel1() {
        Flux publisher = ((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)Flux.just((Object)this.testPayload(0)));
        long count = (Long)publisher.count().block();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test(timeout=10000L)
    public void testChannel3() {
        Flux publisher = ((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)Flux.just((Object[])new Payload[]{this.testPayload(0), this.testPayload(1), this.testPayload(2)}));
        long count = (Long)publisher.count().block();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test(timeout=10000L)
    public void testChannel512() {
        Flux payloads = Flux.range((int)1, (int)512).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assert.assertEquals((long)512L, (long)count);
    }

    @Test(timeout=30000L)
    public void testChannel20_000() {
        Flux payloads = Flux.range((int)1, (int)20000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assert.assertEquals((long)20000L, (long)count);
    }

    @Test(timeout=60000L)
    public void testChannel200_000() {
        Flux payloads = Flux.range((int)1, (int)200000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assert.assertEquals((long)200000L, (long)count);
    }

    @Test(timeout=60000L)
    @Ignore
    public void testChannel2_000_000() {
        AtomicInteger counter = new AtomicInteger(0);
        Flux payloads = Flux.range((int)1, (int)2000000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)((Object)this.setup)).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assert.assertEquals((long)2000000L, (long)count);
    }
}

