/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.uri.UriHandler;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface UriHandlerTest {
    @DisplayName(value="returns empty Optional client with invalid URI")
    @Test
    default public void buildClientInvalidUri() {
        Assertions.assertThat((Optional)this.getUriHandler().buildClient(URI.create(this.getInvalidUri()))).isEmpty();
    }

    @DisplayName(value="buildClient throws NullPointerException with null uri")
    @Test
    default public void buildClientNullUri() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.getUriHandler().buildClient(null)).withMessage("uri must not be null");
    }

    @DisplayName(value="returns client with value URI")
    @Test
    default public void buildClientValidUri() {
        Assertions.assertThat((Optional)this.getUriHandler().buildClient(URI.create(this.getValidUri()))).isNotEmpty();
    }

    @DisplayName(value="returns empty Optional server with invalid URI")
    @Test
    default public void buildServerInvalidUri() {
        Assertions.assertThat((Optional)this.getUriHandler().buildServer(URI.create(this.getInvalidUri()))).isEmpty();
    }

    @DisplayName(value="buildServer throws NullPointerException with null uri")
    @Test
    default public void buildServerNullUri() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.getUriHandler().buildServer(null)).withMessage("uri must not be null");
    }

    @DisplayName(value="returns server with value URI")
    @Test
    default public void buildServerValidUri() {
        Assertions.assertThat((Optional)this.getUriHandler().buildServer(URI.create(this.getValidUri()))).isNotEmpty();
    }

    public String getInvalidUri();

    public UriHandler getUriHandler();

    public String getValidUri();
}

