/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.client.filter;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.stat.FrugalQuantile;
import io.rsocket.stat.Quantile;
import io.rsocket.util.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class BackupRequestSocket
implements RSocket {
    private final ScheduledExecutorService executor;
    private final RSocket child;
    private final Quantile q;

    public BackupRequestSocket(RSocket child, double quantile, ScheduledExecutorService executor) {
        this.child = child;
        this.executor = executor;
        this.q = new FrugalQuantile(quantile);
    }

    public BackupRequestSocket(RSocket child, double quantile) {
        this(child, quantile, Executors.newScheduledThreadPool(2));
    }

    public BackupRequestSocket(RSocket child) {
        this(child, 0.99);
    }

    public Mono<Void> fireAndForget(Payload payload) {
        return this.child.fireAndForget(payload);
    }

    public Mono<Payload> requestResponse(Payload payload) {
        return Mono.from(subscriber -> {
            OneSubscriber oneSubscriber = new OneSubscriber(subscriber);
            FirstRequestSubscriber backupRequest = new FirstRequestSubscriber(oneSubscriber, () -> this.child.requestResponse(payload));
            this.child.requestResponse(payload).subscribe((Subscriber)backupRequest);
        });
    }

    public Flux<Payload> requestStream(Payload payload) {
        return this.child.requestStream(payload);
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.child.requestChannel(payloads);
    }

    public Mono<Void> metadataPush(Payload payload) {
        return this.child.metadataPush(payload);
    }

    public double availability() {
        return this.child.availability();
    }

    public void dispose() {
        this.child.dispose();
    }

    public boolean isDisposed() {
        return this.child.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.child.onClose();
    }

    public String toString() {
        return "BackupRequest(q=" + this.q + ")->" + this.child;
    }

    private class BackupRequestSubscriber<T>
    implements Subscriber<T> {
        private final Subscriber<? super T> oneSubscriber;
        private final Subscription firstRequestSubscription;
        private long start;

        private BackupRequestSubscriber(Subscriber<? super T> oneSubscriber, Subscription firstRequestSubscription) {
            this.oneSubscriber = oneSubscriber;
            this.firstRequestSubscription = firstRequestSubscription;
        }

        public void onSubscribe(Subscription s) {
            this.start = Clock.now();
            s.request(1L);
        }

        public void onNext(T t) {
            this.firstRequestSubscription.cancel();
            this.oneSubscriber.onNext(t);
            long latency = Clock.now() - this.start;
            BackupRequestSocket.this.q.insert(latency);
        }

        public void onError(Throwable t) {
            this.oneSubscriber.onError(t);
        }

        public void onComplete() {
            this.oneSubscriber.onComplete();
        }
    }

    private class FirstRequestSubscriber
    implements Subscriber<Payload> {
        private final Subscriber<? super Payload> oneSubscriber;
        private final Supplier<Publisher<Payload>> action;
        private long start;
        private ScheduledFuture<?> future;

        private FirstRequestSubscriber(Subscriber<? super Payload> oneSubscriber, Supplier<Publisher<Payload>> action) {
            this.oneSubscriber = oneSubscriber;
            this.action = action;
        }

        public void onSubscribe(Subscription s) {
            this.start = Clock.now();
            if (BackupRequestSocket.this.q.estimation() > 0.0) {
                this.future = BackupRequestSocket.this.executor.schedule(() -> this.action.get().subscribe(new BackupRequestSubscriber(this.oneSubscriber, s)), (long)BackupRequestSocket.this.q.estimation(), TimeUnit.MICROSECONDS);
            }
            this.oneSubscriber.onSubscribe(s);
        }

        public void onNext(Payload t) {
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.oneSubscriber.onNext((Object)t);
            long latency = Clock.now() - this.start;
            BackupRequestSocket.this.q.insert(latency);
        }

        public void onError(Throwable t) {
            this.oneSubscriber.onError(t);
        }

        public void onComplete() {
            this.oneSubscriber.onComplete();
        }
    }

    private static class OneSubscriber<T>
    implements Subscriber<T> {
        private final Subscriber<T> subscriber;
        private final AtomicBoolean firstEvent;
        private final AtomicBoolean firstTerminal;

        private OneSubscriber(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
            this.firstEvent = new AtomicBoolean(false);
            this.firstTerminal = new AtomicBoolean(false);
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onNext(T t) {
            if (this.firstEvent.compareAndSet(false, true)) {
                this.subscriber.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (this.firstTerminal.compareAndSet(false, true)) {
                this.subscriber.onError(t);
            }
        }

        public void onComplete() {
            if (this.firstTerminal.compareAndSet(false, true)) {
                this.subscriber.onComplete();
            }
        }
    }
}

