/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.Availability;
import io.rsocket.loadbalance.Ewma;
import io.rsocket.loadbalance.FrugalQuantile;
import io.rsocket.loadbalance.Median;
import io.rsocket.loadbalance.Quantile;
import io.rsocket.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class Stats
implements Availability {
    private static final double DEFAULT_LOWER_QUANTILE = 0.5;
    private static final double DEFAULT_HIGHER_QUANTILE = 0.8;
    private static final int INACTIVITY_FACTOR = 500;
    private static final long DEFAULT_INITIAL_INTER_ARRIVAL_TIME = Clock.unit().convert(1L, TimeUnit.SECONDS);
    private static final double STARTUP_PENALTY = 2.251799813685247E15;
    private final Quantile lowerQuantile;
    private final Quantile higherQuantile;
    private final Ewma errorPercentage;
    private final Median median;
    private final Ewma interArrivalTime;
    private final long tau;
    private final long inactivityFactor;
    private long errorStamp;
    private long stamp;
    private long stamp0;
    private long duration;
    private double availability = 1.0;
    private volatile int pending;
    private volatile long pendingStreams;
    private static final AtomicLongFieldUpdater<Stats> PENDING_STREAMS = AtomicLongFieldUpdater.newUpdater(Stats.class, "pendingStreams");

    private Stats() {
        this(new FrugalQuantile(0.5), new FrugalQuantile(0.8), 500L);
    }

    private Stats(Quantile lowerQuantile, Quantile higherQuantile, long inactivityFactor) {
        long now;
        this.lowerQuantile = lowerQuantile;
        this.higherQuantile = higherQuantile;
        this.inactivityFactor = inactivityFactor;
        this.stamp = now = Clock.now();
        this.errorStamp = now;
        this.stamp0 = now;
        this.duration = 0L;
        this.pending = 0;
        this.median = new Median();
        this.interArrivalTime = new Ewma(1L, TimeUnit.MINUTES, DEFAULT_INITIAL_INTER_ARRIVAL_TIME);
        this.errorPercentage = new Ewma(5L, TimeUnit.SECONDS, 1.0);
        this.tau = Clock.unit().convert((long)(5.0 / Math.log(2.0)), TimeUnit.SECONDS);
    }

    public double errorPercentage() {
        return this.errorPercentage.value();
    }

    public double medianLatency() {
        return this.median.estimation();
    }

    public double lowerQuantileLatency() {
        return this.lowerQuantile.estimation();
    }

    public double higherQuantileLatency() {
        return this.higherQuantile.estimation();
    }

    public double interArrivalTime() {
        return this.interArrivalTime.value();
    }

    public int pending() {
        return this.pending;
    }

    public long lastTimeUsedMillis() {
        return this.stamp0;
    }

    @Override
    public double availability() {
        if (Clock.now() - this.stamp > this.tau) {
            this.recordError(1.0);
        }
        return this.availability * this.errorPercentage.value();
    }

    public synchronized double predictedLatency() {
        double weight;
        long now = Clock.now();
        long elapsed = Math.max(now - this.stamp, 1L);
        double prediction = this.median.estimation();
        if (prediction == 0.0) {
            weight = this.pending == 0 ? 0.0 : 2.251799813685247E15 + (double)this.pending;
        } else if (this.pending == 0 && (double)elapsed > (double)this.inactivityFactor * this.interArrivalTime.value()) {
            this.median.insert(0.0);
            weight = this.median.estimation();
        } else {
            double predicted = prediction * (double)this.pending;
            double instant = this.instantaneous(now);
            weight = predicted < instant ? instant / (double)this.pending : prediction;
        }
        return weight;
    }

    synchronized long instantaneous(long now) {
        return this.duration + (now - this.stamp0) * (long)this.pending;
    }

    public void startStream() {
        PENDING_STREAMS.incrementAndGet(this);
    }

    public void stopStream() {
        PENDING_STREAMS.decrementAndGet(this);
    }

    public synchronized long startRequest() {
        long now = Clock.now();
        this.interArrivalTime.insert(now - this.stamp);
        this.duration += Math.max(0L, now - this.stamp0) * (long)this.pending;
        ++this.pending;
        this.stamp = now;
        this.stamp0 = now;
        return now;
    }

    public synchronized long stopRequest(long timestamp) {
        long now = Clock.now();
        this.duration += Math.max(0L, now - this.stamp0) * (long)this.pending - (now - timestamp);
        --this.pending;
        this.stamp0 = now;
        return now;
    }

    public synchronized void record(double roundTripTime) {
        this.median.insert(roundTripTime);
        this.lowerQuantile.insert(roundTripTime);
        this.higherQuantile.insert(roundTripTime);
    }

    public synchronized void recordError(double value) {
        this.errorPercentage.insert(value);
        this.errorStamp = Clock.now();
    }

    public void setAvailability(double availability) {
        this.availability = availability;
    }

    public String toString() {
        return "Stats{lowerQuantile=" + this.lowerQuantile.estimation() + ", higherQuantile=" + this.higherQuantile.estimation() + ", inactivityFactor=" + this.inactivityFactor + ", tau=" + this.tau + ", errorPercentage=" + this.errorPercentage.value() + ", pending=" + this.pending + ", errorStamp=" + this.errorStamp + ", stamp=" + this.stamp + ", stamp0=" + this.stamp0 + ", duration=" + this.duration + ", median=" + this.median.estimation() + ", interArrivalTime=" + this.interArrivalTime.value() + ", pendingStreams=" + this.pendingStreams + ", availability=" + this.availability + '}';
    }

    public static Stats noOps() {
        return NoOpsStats.INSTANCE;
    }

    public static Stats create() {
        return new Stats();
    }

    public static Stats create(Quantile lowerQuantile, Quantile higherQuantile, long inactivityFactor) {
        return new Stats(lowerQuantile, higherQuantile, inactivityFactor);
    }

    private static final class NoOpsStats
    extends Stats {
        static final Stats INSTANCE = new NoOpsStats();

        private NoOpsStats() {
        }

        @Override
        public double errorPercentage() {
            return 0.0;
        }

        @Override
        public double medianLatency() {
            return 0.0;
        }

        @Override
        public double lowerQuantileLatency() {
            return 0.0;
        }

        @Override
        public double higherQuantileLatency() {
            return 0.0;
        }

        @Override
        public double interArrivalTime() {
            return 0.0;
        }

        @Override
        public int pending() {
            return 0;
        }

        @Override
        public long lastTimeUsedMillis() {
            return 0L;
        }

        @Override
        public double availability() {
            return 1.0;
        }

        @Override
        public double predictedLatency() {
            return 0.0;
        }

        @Override
        long instantaneous(long now) {
            return 0L;
        }

        @Override
        public void startStream() {
        }

        @Override
        public void stopStream() {
        }

        @Override
        public long startRequest() {
            return 0L;
        }

        @Override
        public long stopRequest(long timestamp) {
            return 0L;
        }

        @Override
        public void record(double roundTripTime) {
        }

        @Override
        public void recordError(double value) {
        }

        @Override
        public String toString() {
            return "NoOpsStats{}";
        }
    }
}

