/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.rsocket.frame.ResumeFrameCodec;
import io.rsocket.resume.InMemoryResumableFramesStore;
import io.rsocket.resume.ResumableFramesStore;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.retry.Retry;

public class Resume {
    private static final Logger logger = LoggerFactory.getLogger(Resume.class);
    private Duration sessionDuration = Duration.ofMinutes(2L);
    private boolean cleanupStoreOnKeepAlive;
    private Function<? super ByteBuf, ? extends ResumableFramesStore> storeFactory;
    private Duration streamTimeout = Duration.ofSeconds(10L);
    private Supplier<ByteBuf> tokenSupplier = ResumeFrameCodec::generateResumeToken;
    private Retry retry = Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(1L)).maxBackoff(Duration.ofSeconds(16L)).jitter(1.0).doBeforeRetry(signal -> logger.debug("Connection error", signal.failure()));

    public Resume sessionDuration(Duration sessionDuration) {
        this.sessionDuration = Objects.requireNonNull(sessionDuration);
        return this;
    }

    public Resume cleanupStoreOnKeepAlive() {
        this.cleanupStoreOnKeepAlive = true;
        return this;
    }

    public Resume storeFactory(Function<? super ByteBuf, ? extends ResumableFramesStore> storeFactory) {
        this.storeFactory = storeFactory;
        return this;
    }

    public Resume streamTimeout(Duration streamTimeout) {
        this.streamTimeout = Objects.requireNonNull(streamTimeout);
        return this;
    }

    public Resume retry(Retry retry) {
        this.retry = retry;
        return this;
    }

    public Resume token(Supplier<ByteBuf> supplier) {
        this.tokenSupplier = supplier;
        return this;
    }

    Duration getSessionDuration() {
        return this.sessionDuration;
    }

    boolean isCleanupStoreOnKeepAlive() {
        return this.cleanupStoreOnKeepAlive;
    }

    Function<? super ByteBuf, ? extends ResumableFramesStore> getStoreFactory(String tag) {
        return this.storeFactory != null ? this.storeFactory : token -> new InMemoryResumableFramesStore(tag, 100000);
    }

    Duration getStreamTimeout() {
        return this.streamTimeout;
    }

    Retry getRetry() {
        return this.retry;
    }

    Supplier<ByteBuf> getTokenSupplier() {
        return this.tokenSupplier;
    }
}

