/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.MetadataPushFrameCodec;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

final class MetadataPushRequesterMono
extends Mono<Void>
implements Scannable {
    volatile long state;
    static final AtomicLongFieldUpdater<MetadataPushRequesterMono> STATE = AtomicLongFieldUpdater.newUpdater(MetadataPushRequesterMono.class, "state");
    final ByteBufAllocator allocator;
    final Payload payload;
    final int maxFrameLength;
    final DuplexConnection connection;

    MetadataPushRequesterMono(Payload payload, RequesterResponderSupport requesterResponderSupport) {
        this.allocator = requesterResponderSupport.getAllocator();
        this.payload = payload;
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.connection = requesterResponderSupport.getDuplexConnection();
    }

    public void subscribe(CoreSubscriber<? super Void> actual) {
        ByteBuf metadataRetainedSlice;
        ByteBuf metadata;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            Operators.error(actual, (Throwable)new IllegalStateException("MetadataPushMono allows only a single Subscriber"));
            return;
        }
        Payload p = this.payload;
        try {
            boolean hasMetadata = p.hasMetadata();
            metadata = p.metadata();
            if (!hasMetadata) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                Operators.error(actual, (Throwable)new IllegalArgumentException("Metadata push should have metadata field present"));
                return;
            }
            if (!PayloadValidationUtils.isValidMetadata(this.maxFrameLength, metadata)) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                Operators.error(actual, (Throwable)new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength)));
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            Operators.error(actual, (Throwable)e);
            return;
        }
        try {
            metadataRetainedSlice = metadata.retainedSlice();
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            Operators.error(actual, (Throwable)e);
            return;
        }
        try {
            p.release();
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            metadataRetainedSlice.release();
            Operators.error(actual, (Throwable)e);
            return;
        }
        ByteBuf requestFrame = MetadataPushFrameCodec.encode(this.allocator, metadataRetainedSlice);
        this.connection.sendFrame(0, requestFrame);
        Operators.complete(actual);
    }

    @Nullable
    public Void block(Duration m) {
        return this.block();
    }

    @Nullable
    public Void block() {
        ByteBuf metadataRetainedSlice;
        ByteBuf metadata;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            throw new IllegalStateException("MetadataPushMono allows only a single Subscriber");
        }
        Payload p = this.payload;
        try {
            boolean hasMetadata = p.hasMetadata();
            metadata = p.metadata();
            if (hasMetadata) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                throw new IllegalArgumentException("Metadata push does not support metadata field");
            }
            if (!PayloadValidationUtils.isValidMetadata(this.maxFrameLength, metadata)) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                throw new IllegalArgumentException("Too Big Payload size");
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            throw e;
        }
        try {
            metadataRetainedSlice = metadata.retainedSlice();
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            throw e;
        }
        try {
            p.release();
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            metadataRetainedSlice.release();
            throw e;
        }
        ByteBuf requestFrame = MetadataPushFrameCodec.encode(this.allocator, metadataRetainedSlice);
        this.connection.sendFrame(0, requestFrame);
        return null;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    @NonNull
    public String stepName() {
        return "source(MetadataPushMono)";
    }
}

