/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.PooledRSocket;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RoundRobinLoadbalanceStrategy
implements LoadbalanceStrategy {
    volatile int nextIndex;
    static final AtomicIntegerFieldUpdater<RoundRobinLoadbalanceStrategy> NEXT_INDEX = AtomicIntegerFieldUpdater.newUpdater(RoundRobinLoadbalanceStrategy.class, "nextIndex");

    @Override
    public PooledRSocket select(PooledRSocket[] sockets) {
        int length = sockets.length;
        int indexToUse = Math.abs(NEXT_INDEX.getAndIncrement(this) % length);
        PooledRSocket pooledRSocket = sockets[indexToUse];
        return pooledRSocket;
    }
}

