/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.RSocketClient;
import io.rsocket.loadbalance.LoadbalanceRSocketSource;
import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.RSocketPool;
import io.rsocket.loadbalance.RoundRobinLoadbalanceStrategy;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LoadbalanceRSocketClient
implements RSocketClient {
    private final RSocketPool rSocketPool;

    private LoadbalanceRSocketClient(RSocketPool rSocketPool) {
        this.rSocketPool = rSocketPool;
    }

    @Override
    public Mono<RSocket> source() {
        return Mono.fromSupplier(this.rSocketPool::select);
    }

    @Override
    public Mono<Void> fireAndForget(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().fireAndForget((Payload)p));
    }

    @Override
    public Mono<Payload> requestResponse(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().requestResponse((Payload)p));
    }

    @Override
    public Flux<Payload> requestStream(Mono<Payload> payloadMono) {
        return payloadMono.flatMapMany(p -> this.rSocketPool.select().requestStream((Payload)p));
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.rSocketPool.select().requestChannel(payloads);
    }

    @Override
    public Mono<Void> metadataPush(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(p -> this.rSocketPool.select().metadataPush((Payload)p));
    }

    public void dispose() {
        this.rSocketPool.dispose();
    }

    public static LoadbalanceRSocketClient create(LoadbalanceStrategy loadbalanceStrategy, Publisher<List<LoadbalanceRSocketSource>> rSocketSuppliersPublisher) {
        return new LoadbalanceRSocketClient(new RSocketPool(rSocketSuppliersPublisher, loadbalanceStrategy));
    }

    public static RSocketClient create(Publisher<List<LoadbalanceRSocketSource>> rSocketSuppliersPublisher) {
        return LoadbalanceRSocketClient.create(new RoundRobinLoadbalanceStrategy(), rSocketSuppliersPublisher);
    }
}

