/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.core.FragmentationUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.CancelFrameCodec;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import io.rsocket.internal.UnboundedProcessor;
import java.util.function.Consumer;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

final class SendUtils {
    private static final Consumer<?> DROPPED_ELEMENTS_CONSUMER = data -> {
        try {
            ReferenceCounted referenceCounted = (ReferenceCounted)data;
            referenceCounted.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    };
    static final Context DISCARD_CONTEXT = Operators.enableOnDiscard(null, DROPPED_ELEMENTS_CONSUMER);

    SendUtils() {
    }

    static void sendReleasingPayload(int streamId, FrameType frameType, int mtu, Payload payload, UnboundedProcessor<ByteBuf> sendProcessor, ByteBufAllocator allocator, boolean requester) {
        ByteBuf requestFrame;
        ByteBuf metadataRetainedSlice;
        boolean fragmentable;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata() : null;
        ByteBuf data = payload.data();
        try {
            fragmentable = FragmentationUtils.isFragmentable(mtu, data, metadata, false);
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, requester, false, e);
            throw e;
        }
        if (fragmentable) {
            boolean complete;
            ByteBuf first;
            ByteBuf slicedData = data.slice();
            ByteBuf slicedMetadata = hasMetadata ? metadata.slice() : Unpooled.EMPTY_BUFFER;
            try {
                first = FragmentationUtils.encodeFirstFragment(allocator, mtu, frameType, streamId, hasMetadata, slicedMetadata, slicedData);
            }
            catch (IllegalReferenceCountException e) {
                SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, requester, false, e);
                throw e;
            }
            sendProcessor.onNext(first);
            boolean bl = complete = frameType == FrameType.NEXT_COMPLETE;
            while (slicedData.isReadable() || slicedMetadata.isReadable()) {
                ByteBuf following;
                try {
                    following = FragmentationUtils.encodeFollowsFragment(allocator, mtu, streamId, complete, slicedMetadata, slicedData);
                }
                catch (IllegalReferenceCountException e) {
                    SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, requester, true, e);
                    throw e;
                }
                sendProcessor.onNext(following);
            }
            try {
                payload.release();
            }
            catch (IllegalReferenceCountException e) {
                SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, true, e);
                throw e;
            }
        }
        ByteBuf dataRetainedSlice = data.retainedSlice();
        try {
            metadataRetainedSlice = hasMetadata ? metadata.retainedSlice() : null;
        }
        catch (IllegalReferenceCountException e) {
            dataRetainedSlice.release();
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, requester, false, e);
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            dataRetainedSlice.release();
            if (hasMetadata) {
                metadataRetainedSlice.release();
            }
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, requester, false, e);
            throw e;
        }
        switch (frameType) {
            case REQUEST_FNF: {
                requestFrame = RequestFireAndForgetFrameCodec.encode(allocator, streamId, false, metadataRetainedSlice, dataRetainedSlice);
                break;
            }
            case REQUEST_RESPONSE: {
                requestFrame = RequestResponseFrameCodec.encode(allocator, streamId, false, metadataRetainedSlice, dataRetainedSlice);
                break;
            }
            case PAYLOAD: 
            case NEXT: 
            case NEXT_COMPLETE: {
                requestFrame = PayloadFrameCodec.encode(allocator, streamId, false, frameType == FrameType.NEXT_COMPLETE, frameType != FrameType.PAYLOAD, metadataRetainedSlice, dataRetainedSlice);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported frame type " + (Object)((Object)frameType));
            }
        }
        sendProcessor.onNext(requestFrame);
    }

    static void sendReleasingPayload(int streamId, FrameType frameType, long initialRequestN, int mtu, Payload payload, UnboundedProcessor<ByteBuf> sendProcessor, ByteBufAllocator allocator, boolean complete) {
        ByteBuf requestFrame;
        ByteBuf metadataRetainedSlice;
        boolean fragmentable;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata() : null;
        ByteBuf data = payload.data();
        try {
            fragmentable = FragmentationUtils.isFragmentable(mtu, data, metadata, true);
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, false, e);
            throw e;
        }
        if (fragmentable) {
            ByteBuf first;
            ByteBuf slicedData = data.slice();
            ByteBuf slicedMetadata = hasMetadata ? metadata.slice() : Unpooled.EMPTY_BUFFER;
            try {
                first = FragmentationUtils.encodeFirstFragment(allocator, mtu, initialRequestN, frameType, streamId, hasMetadata, slicedMetadata, slicedData);
            }
            catch (IllegalReferenceCountException e) {
                SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, false, e);
                throw e;
            }
            sendProcessor.onNext(first);
            while (slicedData.isReadable() || slicedMetadata.isReadable()) {
                ByteBuf following;
                try {
                    following = FragmentationUtils.encodeFollowsFragment(allocator, mtu, streamId, complete, slicedMetadata, slicedData);
                }
                catch (IllegalReferenceCountException e) {
                    SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, true, e);
                    throw e;
                }
                sendProcessor.onNext(following);
            }
            try {
                payload.release();
            }
            catch (IllegalReferenceCountException e) {
                SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, true, e);
                throw e;
            }
        }
        ByteBuf dataRetainedSlice = data.retainedSlice();
        try {
            metadataRetainedSlice = hasMetadata ? metadata.retainedSlice() : null;
        }
        catch (IllegalReferenceCountException e) {
            dataRetainedSlice.release();
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, false, e);
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            dataRetainedSlice.release();
            if (hasMetadata) {
                metadataRetainedSlice.release();
            }
            SendUtils.sendTerminalFrame(streamId, frameType, sendProcessor, allocator, true, false, e);
            throw e;
        }
        switch (frameType) {
            case REQUEST_STREAM: {
                requestFrame = RequestStreamFrameCodec.encode(allocator, streamId, false, initialRequestN, metadataRetainedSlice, dataRetainedSlice);
                break;
            }
            case REQUEST_CHANNEL: {
                requestFrame = RequestChannelFrameCodec.encode(allocator, streamId, false, complete, initialRequestN, metadataRetainedSlice, dataRetainedSlice);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported frame type " + (Object)((Object)frameType));
            }
        }
        sendProcessor.onNext(requestFrame);
    }

    static void sendTerminalFrame(int streamId, FrameType frameType, UnboundedProcessor<ByteBuf> sendProcessor, ByteBufAllocator allocator, boolean requester, boolean onFollowingFrame, Throwable t) {
        if (onFollowingFrame) {
            if (requester) {
                ByteBuf cancelFrame = CancelFrameCodec.encode(allocator, streamId);
                sendProcessor.onNext(cancelFrame);
            } else {
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to encode fragmented " + (Object)((Object)frameType) + " frame. Cause: " + t.getMessage()));
                sendProcessor.onNext(errorFrame);
            }
        } else {
            switch (frameType) {
                case PAYLOAD: 
                case NEXT: 
                case NEXT_COMPLETE: {
                    if (requester) {
                        ByteBuf cancelFrame = CancelFrameCodec.encode(allocator, streamId);
                        sendProcessor.onNext(cancelFrame);
                        break;
                    }
                    ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to encode " + (Object)((Object)frameType) + " frame. Cause: " + t.getMessage()));
                    sendProcessor.onNext(errorFrame);
                }
            }
        }
    }
}

