/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.ResponderFrameHandler;
import io.rsocket.core.SendUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.UnboundedProcessor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

final class RequestStreamResponderSubscriber
implements ResponderFrameHandler,
CoreSubscriber<Payload> {
    static final Logger logger = LoggerFactory.getLogger(RequestStreamResponderSubscriber.class);
    final int streamId;
    final long firstRequest;
    final ByteBufAllocator allocator;
    final PayloadDecoder payloadDecoder;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final UnboundedProcessor<ByteBuf> sendProcessor;
    final RSocket handler;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<RequestStreamResponderSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(RequestStreamResponderSubscriber.class, Subscription.class, "s");
    CompositeByteBuf frames;
    boolean done;

    public RequestStreamResponderSubscriber(int streamId, long firstRequest, ByteBuf firstFrame, RequesterResponderSupport requesterResponderSupport, RSocket handler) {
        this.streamId = streamId;
        this.firstRequest = firstRequest;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.sendProcessor = requesterResponderSupport.getSendProcessor();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.handler = handler;
        this.frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), firstFrame, true, this.maxInboundPayloadSize);
    }

    public RequestStreamResponderSubscriber(int streamId, long firstRequest, RequesterResponderSupport requesterResponderSupport) {
        this.streamId = streamId;
        this.firstRequest = firstRequest;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.sendProcessor = requesterResponderSupport.getSendProcessor();
        this.payloadDecoder = null;
        this.handler = null;
        this.frames = null;
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.s, (Subscription)subscription)) {
            long firstRequest = this.firstRequest;
            S.lazySet(this, subscription);
            subscription.request(firstRequest);
        }
    }

    public void onNext(Payload p) {
        if (this.done) {
            ReferenceCountUtil.safeRelease((Object)p);
            return;
        }
        int streamId = this.streamId;
        UnboundedProcessor<ByteBuf> sender = this.sendProcessor;
        ByteBufAllocator allocator = this.allocator;
        if (p == null) {
            ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(allocator, streamId);
            sender.onNext(completeFrame);
            return;
        }
        int mtu = this.mtu;
        try {
            if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                p.release();
                this.handleCancel();
                this.done = true;
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength)));
                sender.onNext(errorFrame);
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            this.handleCancel();
            this.done = true;
            ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to validate payload. Cause" + e.getMessage()));
            sender.onNext(errorFrame);
            return;
        }
        try {
            SendUtils.sendReleasingPayload(streamId, FrameType.NEXT, mtu, p, sender, allocator, false);
        }
        catch (Throwable t) {
            this.handleCancel();
            this.done = true;
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            logger.debug("Dropped error", t);
            return;
        }
        this.done = true;
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            logger.debug("Dropped error", t);
            return;
        }
        CompositeByteBuf frames = this.frames;
        if (frames != null && frames.refCnt() > 0) {
            frames.release();
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, t);
        this.sendProcessor.onNext(errorFrame);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(this.allocator, streamId);
        this.sendProcessor.onNext(completeFrame);
    }

    @Override
    public void handleRequestN(long n) {
        this.s.request(n);
    }

    @Override
    public final void handleCancel() {
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription()) {
            return;
        }
        if (currentSubscription == null) {
            S.lazySet(this, Operators.cancelledSubscription());
            this.requesterResponderSupport.remove(this.streamId, this);
            CompositeByteBuf frames = this.frames;
            if (frames != null) {
                this.frames = null;
                frames.release();
            }
            return;
        }
        if (!S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            return;
        }
        this.requesterResponderSupport.remove(this.streamId, this);
        currentSubscription.cancel();
    }

    @Override
    public void handleNext(ByteBuf followingFrame, boolean hasFollows, boolean isLastPayload) {
        CompositeByteBuf frames = this.frames;
        if (frames == null) {
            return;
        }
        try {
            ReassemblyUtils.addFollowingFrame(frames, followingFrame, hasFollows, this.maxInboundPayloadSize);
        }
        catch (IllegalStateException t) {
            S.lazySet(this, Operators.cancelledSubscription());
            this.requesterResponderSupport.remove(this.streamId, this);
            this.frames = null;
            frames.release();
            logger.debug("Reassembly has failed", (Throwable)t);
            ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, this.streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
            this.sendProcessor.onNext(errorFrame);
            return;
        }
        if (!hasFollows) {
            Payload payload;
            this.frames = null;
            try {
                payload = (Payload)this.payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                S.lazySet(this, Operators.cancelledSubscription());
                this.done = true;
                this.requesterResponderSupport.remove(this.streamId, this);
                ReferenceCountUtil.safeRelease((Object)frames);
                logger.debug("Reassembly has failed", t);
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, this.streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
                this.sendProcessor.onNext(errorFrame);
                return;
            }
            Flux<Payload> source = this.handler.requestStream(payload);
            source.subscribe((CoreSubscriber)this);
        }
    }

    public Context currentContext() {
        return SendUtils.DISCARD_CONTEXT;
    }
}

