/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.rsocket.resume.ClientResume;
import io.rsocket.resume.ResumeStrategy;
import java.time.Duration;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExponentialBackoffResumeStrategy
implements ResumeStrategy {
    private volatile Duration next;
    private final Duration firstBackoff;
    private final Duration maxBackoff;
    private final int factor;

    public ExponentialBackoffResumeStrategy(Duration firstBackoff, Duration maxBackoff, int factor) {
        this.firstBackoff = Objects.requireNonNull(firstBackoff, "firstBackoff");
        this.maxBackoff = Objects.requireNonNull(maxBackoff, "maxBackoff");
        this.factor = ExponentialBackoffResumeStrategy.requirePositive(factor);
    }

    @Override
    public Publisher<?> apply(ClientResume clientResume, Throwable throwable) {
        return Flux.defer(() -> Mono.delay((Duration)this.next()).thenReturn((Object)this.toString()));
    }

    Duration next() {
        this.next = this.next == null ? this.firstBackoff : Duration.ofMillis(Math.min(this.maxBackoff.toMillis(), this.next.toMillis() * (long)this.factor));
        return this.next;
    }

    private static int requirePositive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Value must be positive: " + value);
        }
        return value;
    }

    public String toString() {
        return "ExponentialBackoffResumeStrategy{next=" + this.next + ", firstBackoff=" + this.firstBackoff + ", maxBackoff=" + this.maxBackoff + ", factor=" + this.factor + '}';
    }
}

