/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.rsocket.Availability;
import io.rsocket.exceptions.MissingLeaseException;
import io.rsocket.frame.LeaseFrameFlyweight;
import io.rsocket.lease.Lease;
import io.rsocket.lease.LeaseImpl;
import java.util.function.Consumer;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.ReplayProcessor;

public interface RequesterLeaseHandler
extends Availability,
Disposable {
    public static final RequesterLeaseHandler None = new RequesterLeaseHandler(){

        @Override
        public boolean useLease() {
            return true;
        }

        @Override
        public Exception leaseError() {
            throw new AssertionError((Object)"Error not possible with NOOP leases handler");
        }

        @Override
        public void receive(ByteBuf leaseFrame) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public double availability() {
            return 1.0;
        }
    };

    public boolean useLease();

    public Exception leaseError();

    public void receive(ByteBuf var1);

    public void dispose();

    public static final class Impl
    implements RequesterLeaseHandler {
        private final String tag;
        private final ReplayProcessor<Lease> receivedLease;
        private volatile LeaseImpl currentLease = LeaseImpl.empty();

        public Impl(String tag, Consumer<Flux<Lease>> leaseReceiver) {
            this.tag = tag;
            this.receivedLease = ReplayProcessor.create((int)1);
            leaseReceiver.accept((Flux<Lease>)this.receivedLease);
        }

        @Override
        public boolean useLease() {
            return this.currentLease.use();
        }

        @Override
        public Exception leaseError() {
            LeaseImpl l = this.currentLease;
            String t = this.tag;
            if (!l.isValid()) {
                return new MissingLeaseException(l, t);
            }
            return new MissingLeaseException(t);
        }

        @Override
        public void receive(ByteBuf leaseFrame) {
            LeaseImpl lease;
            int numberOfRequests = LeaseFrameFlyweight.numRequests(leaseFrame);
            int timeToLiveMillis = LeaseFrameFlyweight.ttl(leaseFrame);
            ByteBuf metadata = LeaseFrameFlyweight.metadata(leaseFrame);
            this.currentLease = lease = LeaseImpl.create(timeToLiveMillis, numberOfRequests, metadata);
            this.receivedLease.onNext((Object)lease);
        }

        @Override
        public void dispose() {
            this.receivedLease.onComplete();
        }

        public boolean isDisposed() {
            return this.receivedLease.isTerminated();
        }

        @Override
        public double availability() {
            return this.currentLease.availability();
        }
    }
}

