/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.SetupFrameFlyweight;
import javax.annotation.Nullable;

public abstract class ConnectionSetupPayload
extends AbstractReferenceCounted
implements Payload {
    public static ConnectionSetupPayload create(ByteBuf setupFrame) {
        return new DefaultConnectionSetupPayload(setupFrame);
    }

    public abstract int keepAliveInterval();

    public abstract int keepAliveMaxLifetime();

    public abstract String metadataMimeType();

    public abstract String dataMimeType();

    public abstract int getFlags();

    public abstract boolean willClientHonorLease();

    public abstract boolean isResumeEnabled();

    @Nullable
    public abstract ByteBuf resumeToken();

    @Override
    public ConnectionSetupPayload retain() {
        super.retain();
        return this;
    }

    @Override
    public ConnectionSetupPayload retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public abstract ConnectionSetupPayload touch();

    @Override
    public abstract ConnectionSetupPayload touch(Object var1);

    private static final class DefaultConnectionSetupPayload
    extends ConnectionSetupPayload {
        private final ByteBuf setupFrame;

        public DefaultConnectionSetupPayload(ByteBuf setupFrame) {
            this.setupFrame = setupFrame;
        }

        @Override
        public boolean hasMetadata() {
            return FrameHeaderFlyweight.hasMetadata(this.setupFrame);
        }

        @Override
        public int keepAliveInterval() {
            return SetupFrameFlyweight.keepAliveInterval(this.setupFrame);
        }

        @Override
        public int keepAliveMaxLifetime() {
            return SetupFrameFlyweight.keepAliveMaxLifetime(this.setupFrame);
        }

        @Override
        public String metadataMimeType() {
            return SetupFrameFlyweight.metadataMimeType(this.setupFrame);
        }

        @Override
        public String dataMimeType() {
            return SetupFrameFlyweight.dataMimeType(this.setupFrame);
        }

        @Override
        public int getFlags() {
            return FrameHeaderFlyweight.flags(this.setupFrame);
        }

        @Override
        public boolean willClientHonorLease() {
            return SetupFrameFlyweight.honorLease(this.setupFrame);
        }

        @Override
        public boolean isResumeEnabled() {
            return SetupFrameFlyweight.resumeEnabled(this.setupFrame);
        }

        @Override
        public ByteBuf resumeToken() {
            return SetupFrameFlyweight.resumeToken(this.setupFrame);
        }

        @Override
        public ConnectionSetupPayload touch() {
            this.setupFrame.touch();
            return this;
        }

        @Override
        public ConnectionSetupPayload touch(Object hint) {
            this.setupFrame.touch(hint);
            return this;
        }

        protected void deallocate() {
            this.setupFrame.release();
        }

        @Override
        public ByteBuf sliceMetadata() {
            return SetupFrameFlyweight.metadata(this.setupFrame);
        }

        @Override
        public ByteBuf sliceData() {
            return SetupFrameFlyweight.data(this.setupFrame);
        }

        @Override
        public ByteBuf data() {
            return this.sliceData();
        }

        @Override
        public ByteBuf metadata() {
            return this.sliceMetadata();
        }
    }
}

