/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.rsocket.framing.Frame;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;

public interface DataFrame
extends Frame {
    default public String getDataAsUtf8() {
        return this.getUnsafeData().toString(StandardCharsets.UTF_8);
    }

    default public int getDataLength() {
        return this.getUnsafeData().readableBytes();
    }

    public ByteBuf getUnsafeData();

    default public <T> T mapData(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return function.apply(this.getUnsafeData());
    }
}

