/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.rsocket.framing.FragmentableFrame;
import io.rsocket.framing.Frame;
import io.rsocket.util.DisposableUtils;
import io.rsocket.util.RecyclerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.Disposable;
import reactor.util.annotation.Nullable;

final class FrameReassembler
implements Disposable {
    private static final Recycler<FrameReassembler> RECYCLER = RecyclerFactory.createRecycler(FrameReassembler::new);
    private final Recycler.Handle<FrameReassembler> handle;
    private ByteBufAllocator byteBufAllocator;
    private ReassemblyState state;

    private FrameReassembler(Recycler.Handle<FrameReassembler> handle) {
        this.handle = handle;
    }

    public void dispose() {
        if (this.state != null) {
            DisposableUtils.disposeQuietly(this.state);
        }
        this.byteBufAllocator = null;
        this.state = null;
        this.handle.recycle((Object)this);
    }

    static FrameReassembler createFrameReassembler(ByteBufAllocator byteBufAllocator) {
        return ((FrameReassembler)RECYCLER.get()).setByteBufAllocator(byteBufAllocator);
    }

    @Nullable
    Frame reassemble(Frame frame) {
        Objects.requireNonNull(frame, "frame must not be null");
        if (!(frame instanceof FragmentableFrame)) {
            return frame;
        }
        FragmentableFrame fragmentableFrame = (FragmentableFrame)frame;
        if (fragmentableFrame.isFollowsFlagSet()) {
            if (this.state == null) {
                this.state = new ReassemblyState(fragmentableFrame);
            } else {
                this.state.accumulate(fragmentableFrame);
            }
        } else {
            if (this.state != null) {
                this.state.accumulate(fragmentableFrame);
                Frame reassembledFrame = this.state.createFrame(this.byteBufAllocator);
                this.state.dispose();
                this.state = null;
                return reassembledFrame;
            }
            return fragmentableFrame;
        }
        return null;
    }

    FrameReassembler setByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return this;
    }

    static final class ReassemblyState
    implements Disposable {
        private ByteBuf data;
        private List<FragmentableFrame> fragments = new ArrayList<FragmentableFrame>();
        private ByteBuf metadata;

        ReassemblyState(FragmentableFrame fragment) {
            this.accumulate(fragment);
        }

        public void dispose() {
            this.fragments.forEach(Disposable::dispose);
        }

        void accumulate(FragmentableFrame fragment) {
            this.fragments.add(fragment);
            this.metadata = this.accumulateMetadata(fragment);
            this.data = this.accumulateData(fragment);
        }

        Frame createFrame(ByteBufAllocator byteBufAllocator) {
            FragmentableFrame root = this.fragments.get(0);
            return root.createNonFragment(byteBufAllocator, this.metadata, this.data);
        }

        private ByteBuf accumulateData(FragmentableFrame fragment) {
            ByteBuf data = fragment.getUnsafeData();
            return this.data == null ? data.retain() : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.data, data.retain()});
        }

        @Nullable
        private ByteBuf accumulateMetadata(FragmentableFrame fragment) {
            ByteBuf metadata = fragment.getUnsafeMetadata();
            if (metadata == null) {
                return this.metadata;
            }
            return this.metadata == null ? metadata.retain() : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.metadata, metadata.retain()});
        }
    }
}

