/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.Frame;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import java.util.function.Function;

public final class StreamIdFrame
extends AbstractRecyclableFrame<StreamIdFrame> {
    private static final Recycler<StreamIdFrame> RECYCLER = RecyclerFactory.createRecycler(StreamIdFrame::new);
    private static final int STREAM_ID_BYTES = 4;

    private StreamIdFrame(Recycler.Handle<StreamIdFrame> handle) {
        super(handle);
    }

    public static StreamIdFrame createStreamIdFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (StreamIdFrame)((StreamIdFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    public static StreamIdFrame createStreamIdFrame(ByteBufAllocator byteBufAllocator, int streamId, Frame frame) {
        Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Objects.requireNonNull(frame, "frame must not be null");
        ByteBuf streamIdByteBuf = frame.mapFrame(frameByteBuf -> {
            ByteBuf byteBuf = byteBufAllocator.buffer(4).writeInt(streamId);
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, frameByteBuf.retain()});
        });
        return (StreamIdFrame)((StreamIdFrame)RECYCLER.get()).setByteBuf(streamIdByteBuf);
    }

    public int getStreamId() {
        return this.getByteBuf().getInt(0);
    }

    public ByteBuf getUnsafeFrameWithoutStreamId() {
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(4, byteBuf.readableBytes() - 4).asReadOnly();
    }

    public <T> T mapFrameWithoutStreamId(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return function.apply(this.getUnsafeFrameWithoutStreamId());
    }

    public String toString() {
        return "StreamIdFrame{streamId=" + this.getStreamId() + ", frameWithoutStreamId=" + this.mapFrameWithoutStreamId(ByteBufUtil::hexDump) + '}';
    }
}

