/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableMetadataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.time.Duration;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class LeaseFrame
extends AbstractRecyclableMetadataFrame<LeaseFrame> {
    private static final int OFFSET_TIME_TO_LIVE = 2;
    private static final int OFFSET_NUMBER_OF_REQUESTS = 6;
    private static final int OFFSET_METADATA = 10;
    private static final Recycler<LeaseFrame> RECYCLER = RecyclerFactory.createRecycler(LeaseFrame::new);

    private LeaseFrame(Recycler.Handle<LeaseFrame> handle) {
        super(handle);
    }

    public static LeaseFrame createLeaseFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (LeaseFrame)((LeaseFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    public static LeaseFrame createLeaseFrame(ByteBufAllocator byteBufAllocator, Duration timeToLive, int numberOfRequests, @Nullable ByteBuf metadata) {
        Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Objects.requireNonNull(timeToLive, "timeToLive must not be null");
        NumberUtils.requirePositive(timeToLive.toMillis(), "timeToLive must be a positive duration");
        NumberUtils.requirePositive(numberOfRequests, "numberOfRequests must be positive");
        ByteBuf byteBuf = LeaseFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.LEASE).writeInt(Math.toIntExact(timeToLive.toMillis())).writeInt(numberOfRequests);
        byteBuf = LeaseFrame.appendMetadata(byteBuf, metadata);
        return (LeaseFrame)((LeaseFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    public int getNumberOfRequests() {
        return this.getByteBuf().getInt(6);
    }

    public Duration getTimeToLive() {
        return Duration.ofMillis(this.getByteBuf().getInt(2));
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(10);
    }

    public String toString() {
        return "LeaseFrame{timeToLive=" + this.getTimeToLive() + ", numberOfRequests=" + this.getNumberOfRequests() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + 125;
    }
}

