/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.rsocket.Frame;
import io.rsocket.Payload;
import io.rsocket.frame.SetupFrameFlyweight;
import io.rsocket.framing.FrameType;

public abstract class ConnectionSetupPayload
extends AbstractReferenceCounted
implements Payload {
    public static ConnectionSetupPayload create(Frame setupFrame) {
        Frame.ensureFrameType(FrameType.SETUP, setupFrame);
        return new DefaultConnectionSetupPayload(setupFrame);
    }

    public abstract int keepAliveInterval();

    public abstract int keepAliveMaxLifetime();

    public abstract String metadataMimeType();

    public abstract String dataMimeType();

    public abstract int getFlags();

    public boolean willClientHonorLease() {
        return Frame.isFlagSet(this.getFlags(), 64);
    }

    @Override
    public boolean hasMetadata() {
        return Frame.isFlagSet(this.getFlags(), 256);
    }

    @Override
    public ConnectionSetupPayload retain() {
        super.retain();
        return this;
    }

    @Override
    public ConnectionSetupPayload retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public abstract ConnectionSetupPayload touch();

    @Override
    public abstract ConnectionSetupPayload touch(Object var1);

    private static final class DefaultConnectionSetupPayload
    extends ConnectionSetupPayload {
        private final Frame setupFrame;

        public DefaultConnectionSetupPayload(Frame setupFrame) {
            this.setupFrame = setupFrame;
        }

        @Override
        public int keepAliveInterval() {
            return SetupFrameFlyweight.keepaliveInterval(this.setupFrame.content());
        }

        @Override
        public int keepAliveMaxLifetime() {
            return SetupFrameFlyweight.maxLifetime(this.setupFrame.content());
        }

        @Override
        public String metadataMimeType() {
            return Frame.Setup.metadataMimeType(this.setupFrame);
        }

        @Override
        public String dataMimeType() {
            return Frame.Setup.dataMimeType(this.setupFrame);
        }

        @Override
        public ByteBuf sliceData() {
            return this.setupFrame.sliceData();
        }

        @Override
        public ByteBuf sliceMetadata() {
            return this.setupFrame.sliceMetadata();
        }

        @Override
        public int getFlags() {
            return Frame.Setup.getFlags(this.setupFrame);
        }

        @Override
        public ConnectionSetupPayload touch() {
            this.setupFrame.touch();
            return this;
        }

        @Override
        public ConnectionSetupPayload touch(Object hint) {
            this.setupFrame.touch(hint);
            return this;
        }

        protected void deallocate() {
            this.setupFrame.release();
        }
    }
}

