/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.exceptions;

import io.rsocket.Frame;
import io.rsocket.exceptions.ApplicationErrorException;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.exceptions.ConnectionCloseException;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.exceptions.InvalidException;
import io.rsocket.exceptions.InvalidSetupException;
import io.rsocket.exceptions.RejectedException;
import io.rsocket.exceptions.RejectedResumeException;
import io.rsocket.exceptions.RejectedSetupException;
import io.rsocket.exceptions.UnsupportedSetupException;
import java.util.Objects;

public final class Exceptions {
    private Exceptions() {
    }

    public static RuntimeException from(Frame frame) {
        Objects.requireNonNull(frame, "frame must not be null");
        int errorCode = Frame.Error.errorCode(frame);
        String message = frame.getDataUtf8();
        switch (errorCode) {
            case 513: {
                return new ApplicationErrorException(message);
            }
            case 515: {
                return new CanceledException(message);
            }
            case 258: {
                return new ConnectionCloseException(message);
            }
            case 257: {
                return new ConnectionErrorException(message);
            }
            case 516: {
                return new InvalidException(message);
            }
            case 1: {
                return new InvalidSetupException(message);
            }
            case 514: {
                return new RejectedException(message);
            }
            case 4: {
                return new RejectedResumeException(message);
            }
            case 3: {
                return new RejectedSetupException(message);
            }
            case 2: {
                return new UnsupportedSetupException(message);
            }
        }
        return new IllegalArgumentException(String.format("Invalid Error frame: %d '%s'", errorCode, message));
    }
}

