/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.tracing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.rsocket.rpc.frames.Metadata;
import io.rsocket.rpc.tracing.SpanSubscriber;
import io.rsocket.rpc.tracing.Tag;
import io.rsocket.util.NumberUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Operators;

public class Tracing {
    private Tracing() {
    }

    public static SpanContext deserializeTracingMetadata(Tracer tracer, ByteBuf metadata) {
        if (tracer == null) {
            return null;
        }
        ByteBuf tracing = Metadata.getTracing(metadata);
        if (tracing.readableBytes() < 0) {
            return null;
        }
        Map<String, String> metadataMap = Tracing.byteBufToMap(tracing);
        if (metadataMap.isEmpty()) {
            return null;
        }
        return Tracing.deserializeTracingMetadata(tracer, metadataMap);
    }

    public static SpanContext deserializeTracingMetadata(Tracer tracer, Map<String, String> metadata) {
        TextMapExtractAdapter adapter = new TextMapExtractAdapter(metadata);
        return tracer.extract(Format.Builtin.TEXT_MAP, (Object)adapter);
    }

    public static ByteBuf mapToByteBuf(ByteBufAllocator allocator, Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = allocator.buffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            int keyLength = NumberUtils.requireUnsignedShort((int)ByteBufUtil.utf8Bytes((CharSequence)key));
            byteBuf.writeShort(keyLength);
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)key, (int)keyLength);
            String value = entry.getValue();
            int valueLength = NumberUtils.requireUnsignedShort((int)ByteBufUtil.utf8Bytes((CharSequence)value));
            byteBuf.writeShort(valueLength);
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)value, (int)keyLength);
        }
        return byteBuf;
    }

    public static Map<String, String> byteBufToMap(ByteBuf byteBuf) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (byteBuf.readableBytes() > 0) {
            short keyLength = byteBuf.readShort();
            String key = (String)byteBuf.readCharSequence((int)keyLength, StandardCharsets.UTF_8);
            short valueLength = byteBuf.readShort();
            String value = (String)byteBuf.readCharSequence((int)valueLength, StandardCharsets.UTF_8);
            map.put(key, value);
        }
        return map;
    }

    public static <T> Function<Map<String, String>, Function<? super Publisher<T>, ? extends Publisher<T>>> trace(Tracer tracer, String name, Tag ... tags) {
        return map -> Operators.lift((scannable, subscriber) -> new SpanSubscriber(subscriber, subscriber.currentContext(), tracer, (Map<String, String>)map, name, tags));
    }

    public static <T> Function<Map<String, String>, Function<? super Publisher<T>, ? extends Publisher<T>>> trace() {
        return map -> publisher -> publisher;
    }

    public static <T> Function<SpanContext, Function<? super Publisher<T>, ? extends Publisher<T>>> traceAsChild() {
        return spanContext -> publisher -> publisher;
    }

    public static <T> Function<SpanContext, Function<? super Publisher<T>, ? extends Publisher<T>>> traceAsChild(Tracer tracer, String name, Tag ... tags) {
        return spanContext -> {
            if (spanContext == null) {
                return Operators.lift((scannable, subscriber) -> new SpanSubscriber(subscriber, subscriber.currentContext(), tracer, null, name, tags));
            }
            return Operators.lift((scannable, subscriber) -> new SpanSubscriber(subscriber, subscriber.currentContext(), tracer, null, (SpanContext)spanContext, name, tags));
        };
    }
}

