/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics.om;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Payload;
import io.rsocket.internal.SwitchTransformFlux;
import io.rsocket.rpc.AbstractRSocketService;
import io.rsocket.rpc.annotations.internal.Generated;
import io.rsocket.rpc.annotations.internal.ResourceType;
import io.rsocket.rpc.frames.Metadata;
import io.rsocket.rpc.metrics.Metrics;
import io.rsocket.rpc.metrics.om.BlockingMetricsSnapshotHandler;
import io.rsocket.rpc.metrics.om.MetricsSnapshot;
import io.rsocket.util.ByteBufPayload;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Generated(type=ResourceType.SERVICE, idlClass=BlockingMetricsSnapshotHandler.class)
@Named(value="BlockingMetricsSnapshotHandlerServer")
public final class BlockingMetricsSnapshotHandlerServer
extends AbstractRSocketService {
    private final BlockingMetricsSnapshotHandler service;
    private final Scheduler scheduler;
    private final Function<? super Publisher<Payload>, ? extends Publisher<Payload>> streamMetrics;
    private static final Function<MessageLite, Payload> serializer = new Function<MessageLite, Payload>(){

        @Override
        public Payload apply(MessageLite message) {
            int length = message.getSerializedSize();
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(length);
            try {
                message.writeTo(CodedOutputStream.newInstance((ByteBuffer)byteBuf.internalNioBuffer(0, length)));
                byteBuf.writerIndex(length);
                return ByteBufPayload.create((ByteBuf)byteBuf);
            }
            catch (Throwable t) {
                byteBuf.release();
                throw new RuntimeException(t);
            }
        }
    };

    @Inject
    public BlockingMetricsSnapshotHandlerServer(BlockingMetricsSnapshotHandler service, Optional<Scheduler> scheduler, Optional<MeterRegistry> registry) {
        this.scheduler = scheduler.orElse(Schedulers.elastic());
        this.service = service;
        this.streamMetrics = !registry.isPresent() ? Function.identity() : Metrics.timed(registry.get(), "rsocket.server", "service", "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler", "method", "StreamMetrics");
    }

    @Override
    public String getService() {
        return "io.rsocket.rpc.metrics.om.MetricsSnapshotHandler";
    }

    @Override
    public Class<?> getServiceClass() {
        return this.service.getClass();
    }

    public Mono<Void> fireAndForget(Payload payload) {
        return Mono.error((Throwable)new UnsupportedOperationException("Fire and forget not implemented."));
    }

    public Mono<Payload> requestResponse(Payload payload) {
        return Mono.error((Throwable)new UnsupportedOperationException("Request-Response not implemented."));
    }

    public Flux<Payload> requestStream(Payload payload) {
        return Flux.error((Throwable)new UnsupportedOperationException("Request-Stream not implemented."));
    }

    @Override
    public Flux<Payload> requestChannel(Payload payload, Flux<Payload> publisher) {
        try {
            ByteBuf metadata = payload.sliceMetadata();
            switch (Metadata.getMethod(metadata)) {
                case "StreamMetrics": {
                    Flux messages = publisher.map(BlockingMetricsSnapshotHandlerServer.deserializer(MetricsSnapshot.parser()));
                    return Flux.defer(() -> Flux.fromIterable(this.service.streamMetrics(messages.toIterable(), metadata)).map(serializer).transform(this.streamMetrics)).subscribeOn(this.scheduler);
                }
            }
            return Flux.error((Throwable)new UnsupportedOperationException());
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return new SwitchTransformFlux(payloads, (BiFunction)new BiFunction<Payload, Flux<Payload>, Publisher<? extends Payload>>(){

            @Override
            public Publisher<Payload> apply(Payload payload, Flux<Payload> publisher) {
                return BlockingMetricsSnapshotHandlerServer.this.requestChannel(payload, publisher);
            }
        });
    }

    private static <T> Function<Payload, T> deserializer(final Parser<T> parser) {
        return new Function<Payload, T>(){

            @Override
            public T apply(Payload payload) {
                try {
                    CodedInputStream is = CodedInputStream.newInstance((ByteBuffer)payload.getData());
                    Object object = parser.parseFrom(is);
                    return object;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                finally {
                    payload.release();
                }
            }
        };
    }
}

