/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class MetricsConditionalSubscriber<T>
extends AtomicBoolean
implements Subscription,
Fuseable.ConditionalSubscriber<T> {
    private final Fuseable.ConditionalSubscriber<? super T> actual;
    private final Counter next;
    private final Counter complete;
    private final Counter error;
    private final Counter cancelled;
    private final Timer timer;
    private Subscription s;
    private long start;

    MetricsConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Counter next, Counter complete, Counter error, Counter cancelled, Timer timer) {
        this.actual = actual;
        this.next = next;
        this.complete = complete;
        this.error = error;
        this.cancelled = cancelled;
        this.timer = timer;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            this.start = System.nanoTime();
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        this.next.increment();
        this.actual.onNext(t);
    }

    public boolean tryOnNext(T t) {
        this.next.increment();
        return this.actual.tryOnNext(t);
    }

    public void onError(Throwable t) {
        if (this.compareAndSet(false, true)) {
            this.error.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.compareAndSet(false, true)) {
            this.complete.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        if (this.compareAndSet(false, true)) {
            this.cancelled.increment();
            this.timer.record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.s.cancel();
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }
}

