/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.internal.common.assertion.AssertParameter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.NonNull;

public class UriContainer {
    private final String uri;
    private final Map<String, Object> uriVariables;

    private UriContainer(Builder builder) {
        this.uri = builder.uri;
        this.uriVariables = builder.uriVariables;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, Object> getUriVariables() {
        return this.uriVariables;
    }

    public static Builder newBuilder(@NonNull String uri) {
        AssertParameter.notNull((Object)uri, (String)"uri");
        return new Builder(uri);
    }

    public static final class Builder {
        private String uri;
        private Map<String, Object> uriVariables = new LinkedHashMap<String, Object>();

        private Builder(@NonNull String uri) {
            AssertParameter.notNull((Object)uri, (String)"uri");
            this.uri = uri;
        }

        public Builder uri(@NonNull String uri) {
            AssertParameter.notNull((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        public Builder uriVariables(@NonNull Map<String, Object> uriVariables) {
            AssertParameter.notNull(uriVariables, (String)"uriVariables");
            this.uriVariables = new LinkedHashMap<String, Object>(uriVariables);
            return this;
        }

        public UriContainer build() {
            return new UriContainer(this);
        }
    }
}

